/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.genesis;

import g_mungus.vlib.data.DimensionSettings;
import g_mungus.vlib.dimension.DimensionSettingsManager;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shipwrights.genesis.GenesisBlocks;
import shipwrights.genesis.blockentity.GenesisBlockEntities;
import shipwrights.genesis.item.GenesisCreativeTabs;
import shipwrights.genesis.item.GenesisItems;
import shipwrights.genesis.networking.GenesisNetworking;
import shipwrights.genesis.networking.StopVoidEngineStartSoundPacket;
import shipwrights.genesis.networking.VoidEngineSoundPacket;
import shipwrights.genesis.networking.WormholeTravelSoundPacket;
import shipwrights.genesis.planets.PlanetData;
import shipwrights.genesis.sound.GenesisSounds;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleTypes;

@Mod.EventBusSubscriber
@Mod(value="genesis")
public final class GenesisMod {
    public static final String MOD_ID = "genesis";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"genesis");
    public static final ResourceLocation SPACE_DIM = ResourceLocation.fromNamespaceAndPath((String)"genesis", (String)"great_unknown");
    public static final ResourceLocation WORMHOLE_DIM = ResourceLocation.fromNamespaceAndPath((String)"genesis", (String)"wormhole");
    public static final ResourceLocation ASTEROID_RULE_ID = ResourceLocation.fromNamespaceAndPath((String)"genesis", (String)"asteroid_block_surface_rule");
    public static final int atmosphereExitHeight = 2048;
    public static final int atmosphereEntryHeight = 1440;
    public static final double earthDist = 15000.0;
    public static final double earthSize = 96.0;
    public static final int earthYear = 4608000;
    public static final List<PlanetData> planets = new CopyOnWriteArrayList<PlanetData>();
    private static final List<QueuedMoon> moonQueue = new CopyOnWriteArrayList<QueuedMoon>();

    public GenesisMod(FMLJavaModLoadingContext context) {
        IEventBus eventBus = context.getModEventBus();
        GenesisNetworking.INSTANCE.messageBuilder(WormholeTravelSoundPacket.class, 0).encoder(WormholeTravelSoundPacket::encode).decoder(WormholeTravelSoundPacket::decode).consumerMainThread(WormholeTravelSoundPacket::handle).add();
        GenesisNetworking.INSTANCE.messageBuilder(VoidEngineSoundPacket.class, 1).encoder(VoidEngineSoundPacket::encode).decoder(VoidEngineSoundPacket::decode).consumerMainThread(VoidEngineSoundPacket::handle).add();
        GenesisNetworking.INSTANCE.messageBuilder(StopVoidEngineStartSoundPacket.class, 2).encoder(StopVoidEngineStartSoundPacket::encode).decoder(StopVoidEngineStartSoundPacket::decode).consumerMainThread(StopVoidEngineStartSoundPacket::handle).add();
        GenesisBlocks.BLOCKS.register(eventBus);
        GenesisBlocks.MENU_TYPES.register(eventBus);
        GenesisBlockEntities.BLOCK_ENTITIES.register(eventBus);
        GenesisSounds.SOUND_EVENTS.register(eventBus);
        GenesisItems.ITEMS.register(eventBus);
        GenesisCreativeTabs.register(eventBus);
    }

    public static Optional<PlanetData> registerPlanet(ResourceLocation dimensionID, double size, double gravity, double sunDist, double yearLength, float r, float g, float b) {
        for (PlanetData planet : planets) {
            if (!planet.dimensionID.equals((Object)dimensionID)) continue;
            return Optional.empty();
        }
        if (sunDist * 15000.0 > 2048.0) {
            PlanetData data = new PlanetData(dimensionID, null, size, sunDist, yearLength, r, g, b, gravity);
            planets.add(data);
            DimensionSettingsManager.INSTANCE.addSettings(data.dimensionID, new DimensionSettings(1.0, gravity, true));
            return Optional.of(data);
        }
        LOGGER.warn("Failed to register planet {}, it is too close to the sun!", (Object)dimensionID);
        return Optional.empty();
    }

    public static void registerMoon(ResourceLocation dimensionID, ResourceLocation orbitingDimensionID, double size, double gravity, double orbitRadius, double yearLength, float r, float g, float b) {
        DimensionSettingsManager.INSTANCE.addSettings(dimensionID, new DimensionSettings(1.0, gravity, true));
        moonQueue.add(new QueuedMoon(dimensionID, orbitingDimensionID, size, gravity, orbitRadius, yearLength, r, g, b));
    }

    @ApiStatus.Internal
    public static void finalizeMoons() {
        for (QueuedMoon moon : moonQueue) {
            PlanetData parent = null;
            for (PlanetData planet : planets) {
                if (planet.dimensionID.equals((Object)moon.dimensionID)) {
                    return;
                }
                if (!planet.dimensionID.equals((Object)moon.orbitingDimensionID)) continue;
                parent = planet;
            }
            if (parent != null) {
                planets.add(new PlanetData(moon.dimensionID, parent, moon.size, moon.orbitRadius, moon.yearLength, moon.r, moon.g, moon.b, moon.gravity));
                continue;
            }
            LOGGER.warn("Failed to register moon {}, its parent planet is missing!", (Object)moon.dimensionID);
        }
        moonQueue.clear();
    }

    public static void refreshEntityScaling(Entity entity, Level level) {
        try {
            ScaleData scaleData = ScaleTypes.BASE.getScaleData(entity);
            ScaleData explosionScaleData = ScaleTypes.EXPLOSIONS.getScaleData(entity);
            scaleData.setPersistence(Boolean.valueOf(true));
            explosionScaleData.setPersistence(Boolean.valueOf(true));
            if (GenesisMod.isMiniScale(level)) {
                scaleData.setScale(0.0625f);
                explosionScaleData.setScale(16.0f);
                entity.m_20242_(true);
            } else {
                scaleData.setScale(1.0f);
                explosionScaleData.setScale(1.0f);
                entity.m_20242_(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isMiniScale(ResourceLocation dimensionLocation) {
        return dimensionLocation.equals((Object)SPACE_DIM) || dimensionLocation.equals((Object)WORMHOLE_DIM);
    }

    public static boolean isMiniScale(ResourceKey<Level> dimension) {
        return GenesisMod.isMiniScale(dimension.m_135782_());
    }

    public static boolean isMiniScale(Level level) {
        return GenesisMod.isMiniScale(level.m_46472_().m_135782_());
    }

    public static boolean shouldCancelVoidDamage(ResourceLocation dimensionLocation) {
        return dimensionLocation.equals((Object)SPACE_DIM) || dimensionLocation.equals((Object)WORMHOLE_DIM);
    }

    public static boolean shouldCancelVoidDamage(ResourceKey<Level> dimension) {
        return GenesisMod.shouldCancelVoidDamage(dimension.m_135782_());
    }

    public static boolean shouldCancelVoidDamage(Level level) {
        return GenesisMod.shouldCancelVoidDamage(level.m_46472_().m_135782_());
    }

    public static boolean isSpaceDimension(ResourceLocation dimensionLocation) {
        return dimensionLocation.equals((Object)SPACE_DIM);
    }

    public static boolean isSpaceDimension(ResourceKey<Level> dimension) {
        return GenesisMod.isSpaceDimension(dimension.m_135782_());
    }

    public static boolean isSpaceDimension(Level level) {
        return GenesisMod.isSpaceDimension(level.m_46472_().m_135782_());
    }

    private record QueuedMoon(ResourceLocation dimensionID, ResourceLocation orbitingDimensionID, double size, double gravity, double orbitRadius, double yearLength, float r, float g, float b) {
    }
}

