/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.genesis.block;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import shipwrights.genesis.GenesisBlocks;
import shipwrights.genesis.extension.FallingBlockEntityExtension;
import shipwrights.genesis.mixin.FallingBlockEntityAccessor;

public class AsteroidBlock
extends Block {
    public static final IntegerProperty VARIANT = IntegerProperty.m_61631_((String)"variant", (int)0, (int)9);
    public static final IntegerProperty PALETTE = IntegerProperty.m_61631_((String)"palette", (int)0, (int)5);
    private static final ConcurrentHashMap<BlockPos, Damage> damageMap = new ConcurrentHashMap();
    private static final long DAMAGE_TIMEOUT_MS = 120000L;
    private static final int DESTROY_THRESHOLD = 64;
    private static final int CLEANUP_INTERVAL = 20;
    private static final AtomicInteger damageCounter = new AtomicInteger(0);
    private static List<List<WeightedBlockState>> PALETTE_BLOCKS = null;

    public static void applyDamage(Level level, BlockPos pos, int amount) {
        if (level.m_5776_()) {
            return;
        }
        long now = System.currentTimeMillis();
        Damage damage = damageMap.computeIfAbsent(pos, k -> new Damage(now));
        damage.update(now, amount);
        if (damage.getHits() > 64 && damageMap.remove(pos) != null) {
            level.m_46961_(pos, false);
        }
        if (damageCounter.incrementAndGet() % 20 == 0) {
            AsteroidBlock.cleanupExpiredDamage(now);
        }
    }

    private static void cleanupExpiredDamage(long now) {
        long cutoffTime = now - 120000L;
        damageMap.entrySet().removeIf(entry -> ((Damage)entry.getValue()).getLastUpdatedTime() < cutoffTime);
    }

    public AsteroidBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)VARIANT, (Comparable)Integer.valueOf(0))).m_61124_((Property)PALETTE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{VARIANT, PALETTE});
    }

    public static Vector3d getRotation(int variant) {
        return switch (variant) {
            case 0 -> new Vector3d();
            case 1 -> new Vector3d(0.0, Math.toRadians(22.5), 0.0);
            case 2 -> new Vector3d(0.0, Math.toRadians(45.0), 0.0);
            case 3 -> new Vector3d(0.0, Math.toRadians(-22.5), 0.0);
            case 4 -> new Vector3d(Math.toRadians(22.5), 0.0, 0.0);
            case 5 -> new Vector3d(Math.toRadians(45.0), 0.0, 0.0);
            case 6 -> new Vector3d(Math.toRadians(-22.5), 0.0, 0.0);
            case 7 -> new Vector3d(0.0, 0.0, Math.toRadians(22.5));
            case 8 -> new Vector3d(0.0, 0.0, Math.toRadians(45.0));
            case 9 -> new Vector3d(0.0, 0.0, Math.toRadians(-22.5));
            default -> new Vector3d(0.0, 0.0, 0.0);
        };
    }

    public void m_5581_(Level level, BlockState blockState, BlockHitResult arg3, Projectile arg4) {
        double speed = arg4.m_20184_().m_82553_();
        AsteroidBlock.applyDamage(level, arg3.m_82425_(), (int)Math.ceil(speed * 10.0));
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!level.f_46443_ && !state.m_60713_(newState.m_60734_())) {
            this.spawnFallingBlocks(level, pos, state);
            this.dropItems(level, pos, state);
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }

    private void dropItems(Level level, BlockPos pos, BlockState state) {
        int palette = (Integer)state.m_61143_((Property)PALETTE);
        if (PALETTE_BLOCKS == null) {
            this.setupPalettes();
        }
        List<Item> items = PALETTE_BLOCKS.get(palette).stream().map(weightedBlockState -> weightedBlockState.state.m_60734_().m_5456_()).toList();
        for (Item item : items) {
            AsteroidBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)item, level.f_46441_.m_216339_(32, 64)));
        }
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return false;
    }

    private static Vector3d rotatePoint(double x, double y, double z, Vector3d eulerAngles) {
        double cosX = Math.cos(eulerAngles.x);
        double sinX = Math.sin(eulerAngles.x);
        double cosY = Math.cos(eulerAngles.y);
        double sinY = Math.sin(eulerAngles.y);
        double cosZ = Math.cos(eulerAngles.z);
        double sinZ = Math.sin(eulerAngles.z);
        double y1 = y * cosX - z * sinX;
        double z1 = y * sinX + z * cosX;
        double x2 = x * cosY + z1 * sinY;
        double z2 = -x * sinY + z1 * cosY;
        double x3 = x2 * cosZ - y1 * sinZ;
        double y3 = x2 * sinZ + y1 * cosZ;
        return new Vector3d(x3, y3, z2);
    }

    private void setupPalettes() {
        PALETTE_BLOCKS = List.of(List.of(new WeightedBlockState(Blocks.f_50069_.m_49966_(), 1), new WeightedBlockState(Blocks.f_50334_.m_49966_(), 1), new WeightedBlockState(Blocks.f_49994_.m_49966_(), 1), new WeightedBlockState(Blocks.f_49997_.m_49966_(), 1)), List.of(new WeightedBlockState(Blocks.f_152597_.m_49966_(), 1), new WeightedBlockState(((Block)GenesisBlocks.NULLSTONE.get()).m_49966_(), 1), new WeightedBlockState(Blocks.f_152551_.m_49966_(), 1), new WeightedBlockState(Blocks.f_152469_.m_49966_(), 1)), List.of(new WeightedBlockState(Blocks.f_50353_.m_49966_(), 1), new WeightedBlockState(Blocks.f_50080_.m_49966_(), 1), new WeightedBlockState(Blocks.f_50730_.m_49966_(), 1), new WeightedBlockState(Blocks.f_50706_.m_49966_(), 1)), List.of(new WeightedBlockState(Blocks.f_220843_.m_49966_(), 1), new WeightedBlockState(Blocks.f_50122_.m_49966_(), 1), new WeightedBlockState(Blocks.f_152599_.m_49966_(), 1), new WeightedBlockState(Blocks.f_152537_.m_49966_(), 1)), List.of(new WeightedBlockState(((Block)GenesisBlocks.WARPSTONE.get()).m_49966_(), 1), new WeightedBlockState(((Block)GenesisBlocks.WARPSTONE_ORE.get()).m_49966_(), 1), new WeightedBlockState(((Block)GenesisBlocks.RIFTROCK.get()).m_49966_(), 1), new WeightedBlockState(((Block)GenesisBlocks.ECHOSTONE.get()).m_49966_(), 1)), List.of(new WeightedBlockState(Blocks.f_152496_.m_49966_(), 1), new WeightedBlockState(Blocks.f_152550_.m_49966_(), 1), new WeightedBlockState(Blocks.f_152468_.m_49966_(), 1), new WeightedBlockState(Blocks.f_152506_.m_49966_(), 1)));
    }

    private static BlockState selectWeightedRandom(List<WeightedBlockState> blocks, RandomSource random) {
        int totalWeight = blocks.stream().mapToInt(w -> w.weight).sum();
        int randomValue = random.m_188503_(totalWeight);
        int currentWeight = 0;
        for (WeightedBlockState weighted : blocks) {
            if (randomValue >= (currentWeight += weighted.weight)) continue;
            return weighted.state;
        }
        return blocks.get((int)0).state;
    }

    private void spawnFallingBlocks(Level level, BlockPos pos, BlockState state) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (PALETTE_BLOCKS == null) {
            this.setupPalettes();
        }
        int variant = (Integer)state.m_61143_((Property)VARIANT);
        int palette = (Integer)state.m_61143_((Property)PALETTE);
        Vector3d rotation = AsteroidBlock.getRotation(variant);
        List<WeightedBlockState> paletteBlocks = PALETTE_BLOCKS.get(palette);
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    boolean isOuterLayer;
                    boolean bl = isOuterLayer = x < 2 || x >= 14 || y < 2 || y >= 14 || z < 2 || z >= 14;
                    if (!isOuterLayer || serverLevel.f_46441_.m_188500_() > 0.125) continue;
                    double relX = (double)x + 0.5 - 8.0;
                    double relY = (double)y + 0.5 - 8.0;
                    double relZ = (double)z + 0.5 - 8.0;
                    Vector3d rotated = AsteroidBlock.rotatePoint(relX, relY, relZ, rotation);
                    double offsetX = (rotated.x + 8.0) / 16.0;
                    double offsetY = (rotated.y + 8.0) / 16.0;
                    double offsetZ = (rotated.z + 8.0) / 16.0;
                    BlockState blockState = AsteroidBlock.selectWeightedRandom(paletteBlocks, serverLevel.f_46441_);
                    FallingBlockEntity fallingBlock = FallingBlockEntityAccessor.invokeConstructor((Level)serverLevel, (double)pos.m_123341_() + offsetX, (double)pos.m_123342_() + offsetY, (double)pos.m_123343_() + offsetZ, blockState);
                    double dirX = rotated.x;
                    double dirY = rotated.y;
                    double dirZ = rotated.z;
                    double length = Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
                    double driftStrength = 0.25 + level.f_46441_.m_188500_() / 4.0;
                    if (length > 0.0) {
                        dirX = dirX / length * driftStrength;
                        dirY = dirY / length * driftStrength;
                        dirZ = dirZ / length * driftStrength;
                    }
                    fallingBlock.m_20334_(dirX, dirY, dirZ);
                    ((FallingBlockEntityExtension)fallingBlock).genesis$setRotation(new Vector3d((Vector3dc)rotation));
                    fallingBlock.f_31943_ = false;
                    fallingBlock.f_31942_ = 400 + level.f_46441_.m_216339_(0, 100);
                    serverLevel.m_7967_((Entity)fallingBlock);
                }
            }
        }
    }

    private static class Damage {
        private final AtomicLong lastUpdatedTime;
        private final AtomicInteger numHits;

        public Damage(long lastUpdatedTime) {
            this.lastUpdatedTime = new AtomicLong(lastUpdatedTime);
            this.numHits = new AtomicInteger(0);
        }

        public void update(long time, int amount) {
            this.lastUpdatedTime.set(time);
            this.numHits.addAndGet(amount);
        }

        public int getHits() {
            return this.numHits.get();
        }

        public long getLastUpdatedTime() {
            return this.lastUpdatedTime.get();
        }
    }

    private static class WeightedBlockState {
        final BlockState state;
        final int weight;

        WeightedBlockState(BlockState state, int weight) {
            this.state = state;
            this.weight = weight;
        }
    }
}

