/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.genesis.block;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import javax.imageio.ImageIO;
import shipwrights.genesis.block.AsteroidTextureLayout;

public class AsteroidTextureGenerator {
    private static final String moj_assets_path = "/Users/<user>/.gradle/caches/fabric-loom/1.20.1/forge/1.20.1-47.4.0/client-extra/assets/minecraft/textures/block/";
    private static final String genesis_assets_path = "src/main/resources/assets/genesis/textures/block/";

    public static void main(String[] args) {
        try {
            AsteroidTextureGenerator.generate();
            System.out.println("Texture generation complete!");
        }
        catch (IOException e) {
            System.err.println("Error generating texture: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void generate() throws IOException {
        String[] rockTextures = new String[]{"/Users/<user>/.gradle/caches/fabric-loom/1.20.1/forge/1.20.1-47.4.0/client-extra/assets/minecraft/textures/block/tuff.png", "/Users/<user>/.gradle/caches/fabric-loom/1.20.1/forge/1.20.1-47.4.0/client-extra/assets/minecraft/textures/block/deepslate_iron_ore.png", "/Users/<user>/.gradle/caches/fabric-loom/1.20.1/forge/1.20.1-47.4.0/client-extra/assets/minecraft/textures/block/deepslate_copper_ore.png", "/Users/<user>/.gradle/caches/fabric-loom/1.20.1/forge/1.20.1-47.4.0/client-extra/assets/minecraft/textures/block/deepslate.png"};
        AsteroidTextureGenerator.generate("asteroid", 16, rockTextures);
    }

    public static void generate(String baseName, int gridSize, String[] texturePaths) throws IOException {
        AsteroidTextureLayout layout = AsteroidTextureLayout.generate(gridSize, texturePaths.length);
        int[][] grid = layout.data;
        int tileSize = 16;
        int imageSize = gridSize * tileSize;
        BufferedImage outputImage = new BufferedImage(imageSize, imageSize, 2);
        BufferedImage[] sourceTextures = new BufferedImage[texturePaths.length];
        for (int i = 0; i < texturePaths.length; ++i) {
            File sourceFile = new File(texturePaths[i]);
            if (sourceFile.exists()) {
                sourceTextures[i] = ImageIO.read(sourceFile);
                System.out.println("Loaded texture: " + texturePaths[i]);
                continue;
            }
            System.err.println("Warning: Source texture not found: " + texturePaths[i]);
            sourceTextures[i] = new BufferedImage(tileSize, tileSize, 2);
        }
        for (int y = 0; y < gridSize; ++y) {
            for (int x = 0; x < gridSize; ++x) {
                int textureId = grid[y][x];
                BufferedImage sourceTile = sourceTextures[textureId % sourceTextures.length];
                for (int ty = 0; ty < tileSize; ++ty) {
                    for (int tx = 0; tx < tileSize; ++tx) {
                        int rgb = sourceTile.getRGB(tx, ty);
                        outputImage.setRGB(x * tileSize + tx, y * tileSize + ty, rgb);
                    }
                }
            }
        }
        String outputFilename = String.format("%s_combined.png", baseName);
        File outputFile = new File(new Random().nextInt(9999) + outputFilename);
        ImageIO.write((RenderedImage)outputImage, "png", outputFile);
        System.out.println("Generated texture: " + outputFilename + " (" + imageSize + "x" + imageSize + " pixels)");
    }
}

