/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.genesis.block;

import java.util.Random;

public class AsteroidTextureLayout {
    public final int size;
    public final int paletteSize;
    private int[] edgeTemplate;
    public final int[][] data;

    public static AsteroidTextureLayout generate(int size, int paletteSize) {
        AsteroidTextureLayout result = new AsteroidTextureLayout(size, paletteSize);
        Random random = new Random();
        result.generateEdgeTemplate(random);
        result.populateData(random);
        return result;
    }

    private void generateEdgeTemplate(Random random) {
        this.edgeTemplate = new int[this.size / 2];
        for (int i = 0; i < this.size / 2; ++i) {
            this.edgeTemplate[i] = random.nextInt(this.paletteSize);
        }
    }

    private void populateData(Random random) {
        for (int y = 0; y < this.size; ++y) {
            for (int x = 0; x < this.size; ++x) {
                this.data[y][x] = (y == 0 || y == this.size - 1) && x < this.size / 2 ? this.edgeTemplate[x] : ((y == 0 || y == this.size - 1) && x >= this.size / 2 ? this.edgeTemplate[this.size - 1 - x] : ((x == 0 || x == this.size - 1) && y < this.size / 2 ? this.edgeTemplate[y] : ((x == 0 || x == this.size - 1) && y >= this.size / 2 ? this.edgeTemplate[this.size - 1 - y] : random.nextInt(this.paletteSize))));
            }
        }
    }

    private AsteroidTextureLayout(int size, int paletteSize) {
        this.size = size;
        this.paletteSize = paletteSize;
        this.data = new int[size][size];
    }
}

