/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.genesis.blockentity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import shipwrights.genesis.GenesisBlocks;
import shipwrights.genesis.block.VoidCoreBlock;
import shipwrights.genesis.blockentity.GenesisBlockEntities;

public class VoidCoreBlockEntity
extends BlockEntity {
    public List<Block> frameBlocks = List.of((Block)GenesisBlocks.VOID_ENGINE_FRAME.get(), (Block)GenesisBlocks.VOID_ENGINE_VIEWPORT.get());

    public VoidCoreBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)GenesisBlockEntities.VOID_CORE.get(), pos, state);
    }

    public static void updateVoidCore(BlockPos framePos, LevelReader level) {
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                for (int z = -1; z < 2; ++z) {
                    BlockEntity blockEntity = level.m_7702_(framePos.m_7918_(x, y, z));
                    if (!(blockEntity instanceof VoidCoreBlockEntity)) continue;
                    ((VoidCoreBlockEntity)blockEntity).updateDormancy();
                    return;
                }
            }
        }
    }

    private void updateDormancy() {
        if (this.f_58857_ == null) {
            return;
        }
        int frames = 0;
        int interfaces = 0;
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                for (int z = -1; z < 2; ++z) {
                    BlockPos framePos = this.m_58899_().m_7918_(x, y, z);
                    if (this.frameBlocks.stream().anyMatch(arg_0 -> ((BlockState)this.f_58857_.m_8055_(framePos)).m_60713_(arg_0))) {
                        ++frames;
                        continue;
                    }
                    if (!this.f_58857_.m_8055_(framePos).m_60713_((Block)GenesisBlocks.VOID_ENGINE_INTERFACE.get())) continue;
                    ++interfaces;
                }
            }
        }
        if (frames == 25 && interfaces == 1) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)((Block)GenesisBlocks.VOID_CORE.get()).m_49966_().m_61124_((Property)VoidCoreBlock.DORMANT, (Comparable)Boolean.valueOf(false)), 2);
        } else {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)((Block)GenesisBlocks.VOID_CORE.get()).m_49966_().m_61124_((Property)VoidCoreBlock.DORMANT, (Comparable)Boolean.valueOf(true)), 2);
        }
    }
}

