/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.genesis.blockentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import shipwrights.genesis.GenesisMod;
import shipwrights.genesis.block.VoidCoreBlock;
import shipwrights.genesis.blockentity.GenesisBlockEntities;
import shipwrights.genesis.networking.GenesisNetworking;
import shipwrights.genesis.networking.StopVoidEngineStartSoundPacket;
import shipwrights.genesis.networking.VoidEngineSoundPacket;
import shipwrights.genesis.networking.WormholeTravelSoundPacket;
import shipwrights.genesis.teleportation.TeleportationHandler;

public class VoidEngineInterfaceBlockEntity
extends BlockEntity {
    private static final int MAX_ENERGY = 8192;
    private static final int ENERGY_PER_TICK = 512;
    private final EnergyStorage energyStorage = new EnergyStorage(8192);
    private final LazyOptional<IEnergyStorage> energyCapability = LazyOptional.of(() -> this.energyStorage);
    private int chargeUpTicks = 0;
    boolean active = false;
    private ResourceLocation returningDim = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"overworld");

    public VoidEngineInterfaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)GenesisBlockEntities.VOID_ENGINE_INTERFACE.get(), pos, state);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.energyStorage.deserializeNBT(tag.m_128423_("energy"));
        this.chargeUpTicks = tag.m_128451_("chargeUpTicks");
        this.active = tag.m_128471_("active");
        this.returningDim = ResourceLocation.parse((String)tag.m_128461_("returningDim"));
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("energy", this.energyStorage.serializeNBT());
        tag.m_128405_("chargeUpTicks", this.chargeUpTicks);
        tag.m_128379_("active", this.active);
        tag.m_128359_("returningDim", this.returningDim.toString());
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (blockEntity instanceof VoidEngineInterfaceBlockEntity) {
            BlockState core;
            VoidEngineInterfaceBlockEntity voidEngineInterface = (VoidEngineInterfaceBlockEntity)blockEntity;
            if (voidEngineInterface.energyStorage.getEnergyStored() < voidEngineInterface.energyStorage.getMaxEnergyStored()) {
                for (Direction direction : Direction.values()) {
                    BlockEntity neighbor = level.m_7702_(pos.m_121945_(direction));
                    if (neighbor == null) continue;
                    neighbor.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).ifPresent(energy -> {
                        int toExtract = Math.min(128, voidEngineInterface.energyStorage.getMaxEnergyStored() - voidEngineInterface.energyStorage.getEnergyStored());
                        int extracted = energy.extractEnergy(toExtract, false);
                        voidEngineInterface.energyStorage.receiveEnergy(extracted, false);
                    });
                }
            }
            if ((core = level.m_8055_(pos.m_121955_(((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122436_().m_142393_(-1)))).m_61138_((Property)VoidCoreBlock.DORMANT) && !((Boolean)core.m_61143_((Property)VoidCoreBlock.DORMANT)).booleanValue()) {
                Ship ship = VSGameUtilsKt.getShipManagingPos((Level)level, (BlockPos)pos);
                Vec3 center = pos.m_252807_();
                if (ship == null) {
                    if (level.m_8055_(pos).m_61138_((Property)BlockStateProperties.f_61448_) && ((Boolean)level.m_8055_(pos).m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) {
                        VoidEngineInterfaceBlockEntity.explode(level, center);
                    }
                } else {
                    boolean hasEnergy;
                    boolean isPowered = level.m_8055_(pos).m_61138_((Property)BlockStateProperties.f_61448_) && (Boolean)level.m_8055_(pos).m_61143_((Property)BlockStateProperties.f_61448_) != false;
                    boolean bl = hasEnergy = voidEngineInterface.energyStorage.getEnergyStored() >= 512;
                    if (isPowered && hasEnergy) {
                        voidEngineInterface.energyStorage.extractEnergy(512, false);
                        if (!voidEngineInterface.active && voidEngineInterface.chargeUpTicks >= 0) {
                            voidEngineInterface.active = true;
                            GenesisMod.LOGGER.info("Current dimension id: {}", (Object)level.m_46472_().m_135782_());
                            if (!level.m_46472_().m_135782_().equals((Object)GenesisMod.WORMHOLE_DIM)) {
                                GenesisNetworking.sendToAll(GenesisNetworking.INSTANCE, new VoidEngineSoundPacket(pos));
                            }
                        }
                        if (!level.m_46472_().m_135782_().equals((Object)GenesisMod.WORMHOLE_DIM) && level.m_7654_() != null) {
                            ++voidEngineInterface.chargeUpTicks;
                            if (voidEngineInterface.chargeUpTicks == 244) {
                                voidEngineInterface.chargeUpTicks = 2;
                                voidEngineInterface.returningDim = level.m_46472_().m_135782_();
                                ServerLevel wormholeLevel = level.m_7654_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)GenesisMod.WORMHOLE_DIM));
                                if (wormholeLevel != null) {
                                    TeleportationHandler teleportationHandler = new TeleportationHandler((ServerLevel)level, wormholeLevel, false);
                                    Vector3d targetPos = ship.getTransform().getPositionInWorld().mul(0.03125, new Vector3d());
                                    teleportationHandler.addShip((ServerShip)ship, (Vector3dc)targetPos, (Quaterniondc)new Quaterniond());
                                    teleportationHandler.finalizeTeleport();
                                    Vector3d worldPos = ship.getShipToWorld().transformPosition(center.f_82479_, center.f_82480_, center.f_82481_, new Vector3d());
                                    GenesisNetworking.sendToAll(GenesisNetworking.INSTANCE, new WormholeTravelSoundPacket(pos));
                                }
                                return;
                            }
                        } else {
                            voidEngineInterface.chargeUpTicks = 32;
                        }
                    } else {
                        if (voidEngineInterface.chargeUpTicks > 0) {
                            --voidEngineInterface.chargeUpTicks;
                        }
                        if (level.m_46472_().m_135782_().equals((Object)GenesisMod.WORMHOLE_DIM) && level.m_7654_() != null) {
                            if (voidEngineInterface.chargeUpTicks <= 0) {
                                voidEngineInterface.chargeUpTicks = -64;
                                ServerLevel returnLevel = level.m_7654_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)voidEngineInterface.returningDim));
                                if (returnLevel != null) {
                                    TeleportationHandler teleportationHandler = new TeleportationHandler((ServerLevel)level, returnLevel, true);
                                    Vector3d targetPos = ship.getTransform().getPositionInWorld().mul(32.0, new Vector3d());
                                    teleportationHandler.addShip((ServerShip)ship, (Vector3dc)targetPos, (Quaterniondc)new Quaterniond());
                                    teleportationHandler.finalizeTeleport();
                                    GenesisNetworking.sendToAll(GenesisNetworking.INSTANCE, new WormholeTravelSoundPacket(pos));
                                }
                            }
                        } else if (voidEngineInterface.chargeUpTicks > 0) {
                            voidEngineInterface.chargeUpTicks = 0;
                            GenesisNetworking.sendToAll(GenesisNetworking.INSTANCE, new StopVoidEngineStartSoundPacket());
                        }
                    }
                }
            }
            if (voidEngineInterface.chargeUpTicks < 0) {
                ++voidEngineInterface.chargeUpTicks;
            }
            if (voidEngineInterface.active && voidEngineInterface.chargeUpTicks == 0) {
                voidEngineInterface.active = false;
            }
        }
    }

    private static void explode(Level level, Vec3 center) {
        level.m_254849_(null, center.f_82479_, center.f_82480_, center.f_82481_, 16.0f, Level.ExplosionInteraction.BLOCK);
    }
}

