/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.genesis.blockentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import shipwrights.genesis.blockentity.GenesisBlockEntities;
import shipwrights.genesis.item.GenesisItems;
import shipwrights.genesis.util.AdaptedEnergyStorage;

public class WarpstoneCatalyzerBlockEntity
extends BlockEntity {
    public static final String ITEMS_TAG = "Inventory";
    public static final String ENERGY_TAG = "Energy";
    public static final int GENERATE = 200;
    public static final int MAXTRANSFER = 1000;
    public static final int CAPACITY = 2000000;
    public static int SLOT_COUNT = 1;
    public static int SLOT = 0;
    private final ItemStackHandler items = this.createItemHandler();
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> this.items);
    private final EnergyStorage energy = this.createEnergyStorage();
    private final LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> new AdaptedEnergyStorage((IEnergyStorage)this.energy){

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        @Override
        public boolean canReceive() {
            return false;
        }
    });
    private int burnTime;

    public WarpstoneCatalyzerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)GenesisBlockEntities.WARPSTONE_CATALYZER_BLOCK_ENTITY.get(), pos, state);
    }

    public void tickServer() {
        this.generateEnergy();
        this.distributeEnergy();
    }

    private void generateEnergy() {
        if (this.energy.getEnergyStored() < this.energy.getMaxEnergyStored()) {
            if (this.burnTime <= 0) {
                ItemStack fuel = this.items.getStackInSlot(SLOT);
                if (fuel.m_41619_() || !fuel.m_150930_((Item)GenesisItems.WARPSTONE_CHUNK.get())) {
                    return;
                }
                this.setBurnTime(600);
                this.items.extractItem(SLOT, 1, false);
            } else {
                this.setBurnTime(this.burnTime - 1);
                this.energy.receiveEnergy(200, false);
            }
            this.m_6596_();
        }
    }

    private void setBurnTime(int bt) {
        if (bt == this.burnTime) {
            return;
        }
        this.burnTime = bt;
        if ((Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61448_) != this.burnTime > 0) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(this.burnTime > 0)));
        }
        this.m_6596_();
    }

    private void distributeEnergy() {
        for (Direction direction : Direction.values()) {
            if (this.energy.getEnergyStored() <= 0) {
                return;
            }
            BlockEntity be = this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction));
            if (be == null) continue;
            be.getCapability(ForgeCapabilities.ENERGY).map(e -> {
                if (e.canReceive()) {
                    int received = e.receiveEnergy(Math.min(this.energy.getEnergyStored(), 1000), false);
                    this.energy.extractEnergy(received, false);
                    this.m_6596_();
                    return received;
                }
                return 0;
            });
        }
    }

    public ItemStackHandler getItems() {
        return this.items;
    }

    public int getStoredPower() {
        return this.energy.getEnergyStored();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(ITEMS_TAG, (Tag)this.items.serializeNBT());
        tag.m_128365_(ENERGY_TAG, this.energy.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(ITEMS_TAG)) {
            this.items.deserializeNBT(tag.m_128469_(ITEMS_TAG));
        }
        if (tag.m_128441_(ENERGY_TAG)) {
            this.energy.deserializeNBT(tag.m_128423_(ENERGY_TAG));
        }
    }

    @Nonnull
    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(SLOT_COUNT){

            protected void onContentsChanged(int slot) {
                WarpstoneCatalyzerBlockEntity.this.m_6596_();
            }
        };
    }

    @Nonnull
    private EnergyStorage createEnergyStorage() {
        return new EnergyStorage(2000000, 1000, 1000);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandler.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }
}

