/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.genesis.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class DimensionEffects
extends DimensionSpecialEffects {
    private final int starBufferCount = 3;
    private final List<VertexBuffer> starBuffers = new ArrayList<VertexBuffer>(3);
    private final List<Vector4fc> starColors = List.of(new Vector4f(1.0f, 1.0f, 1.0f, 0.8f), new Vector4f(0.8f, 0.8f, 1.0f, 0.8f), new Vector4f(1.0f, 1.0f, 0.8f, 0.8f));

    public DimensionEffects() {
        super(Float.NaN, false, DimensionSpecialEffects.SkyType.NONE, false, false);
        this.createStars();
    }

    public Vec3 m_5927_(Vec3 arg, float f) {
        return new Vec3(0.0, 0.0, 0.0);
    }

    public boolean m_5781_(int i, int j) {
        return false;
    }

    public float @Nullable [] m_7518_(float f, float g) {
        return null;
    }

    public boolean renderSnowAndRain(ClientLevel level, int ticks, float partialTick, LightTexture lightTexture, double camX, double camY, double camZ) {
        return true;
    }

    public boolean tickRain(ClientLevel level, int ticks, Camera camera) {
        return true;
    }

    public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        FogRenderer.m_109017_();
        for (int i = 0; i < 3; ++i) {
            Vector4fc color = this.starColors.get(i);
            RenderSystem.setShaderColor((float)color.x(), (float)color.y(), (float)color.z(), (float)color.w());
            VertexBuffer starBuffer = this.starBuffers.get(i);
            starBuffer.m_85921_();
            starBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, GameRenderer.m_172808_());
            VertexBuffer.m_85931_();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return true;
    }

    private void createStars() {
        this.starBuffers.forEach(VertexBuffer::close);
        this.starBuffers.clear();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        for (int i = 0; i < 3; ++i) {
            VertexBuffer starBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            BufferBuilder.RenderedBuffer renderedBuffer = this.drawStars(bufferbuilder, 10842L / (long)(i + 4));
            starBuffer.m_85921_();
            starBuffer.m_231221_(renderedBuffer);
            VertexBuffer.m_85931_();
            this.starBuffers.add(starBuffer);
        }
    }

    private BufferBuilder.RenderedBuffer drawStars(BufferBuilder bufferbuilder, long seed) {
        RandomSource randomsource = RandomSource.m_216335_((long)seed);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        for (int i = 0; i < 1600; ++i) {
            double d0 = randomsource.m_188501_() * 2.0f - 1.0f;
            double d1 = randomsource.m_188501_() * 2.0f - 1.0f;
            double d2 = randomsource.m_188501_() * 2.0f - 1.0f;
            double d3 = 0.05f + randomsource.m_188501_() * 0.2f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = randomsource.m_188500_() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d17 = 0.0;
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d20 = 0.0;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + d17 * d13;
                double d24 = d17 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                bufferbuilder.m_5483_(d5 + d25, d6 + d23, d7 + d26).m_5752_();
            }
        }
        return bufferbuilder.m_231175_();
    }
}

