/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.genesis.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import shipwrights.genesis.GenesisMod;
import shipwrights.genesis.client.ShaderRegistry;
import shipwrights.genesis.client.SunRenderer;
import shipwrights.genesis.planets.PlanetData;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class PlanetRenderer {
    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_SKY) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null || !GenesisMod.isSpaceDimension((Level)level)) {
            return;
        }
        long ticks = level.m_46467_();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.depthFunc((int)515);
        RenderSystem.enableCull();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer planetBuffer = bufferSource.m_6299_((RenderType)ShaderRegistry.getPlanetRenderType());
        for (PlanetData planet : GenesisMod.planets) {
            PlanetRenderer.renderPlanet(event, planet, planetBuffer, ticks);
        }
        bufferSource.m_109912_((RenderType)ShaderRegistry.getPlanetRenderType());
        VertexConsumer sunBuffer = bufferSource.m_6299_((RenderType)ShaderRegistry.getSunRenderType());
        SunRenderer.renderSun(event, sunBuffer);
        bufferSource.m_109912_((RenderType)ShaderRegistry.getSunRenderType());
        RenderSystem.enableDepthTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableCull();
    }

    private static void renderPlanet(RenderLevelStageEvent event, PlanetData data, VertexConsumer buffer, long ticks) {
        Matrix4f matrix;
        PoseStack poseStack = event.getPoseStack();
        try {
            matrix = (Matrix4f)poseStack.m_85850_().m_252922_().clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        Vector3d pos = data.getCurrentPos(ticks, event.getPartialTick());
        matrix.translate((float)(pos.x - event.getCamera().m_90583_().f_82479_), (float)(pos.y - event.getCamera().m_90583_().f_82480_), (float)(pos.z - event.getCamera().m_90583_().f_82481_));
        matrix.rotate((Quaternionfc)new Quaternionf().rotationXYZ((float)data.rotation.x, (float)data.rotation.y, (float)data.rotation.z));
        float halfSize = (float)(data.getActualSize() / 2.0);
        int textureScale = data.hash % 256;
        PlanetRenderer.addCubeFacePlanet(matrix, buffer, -halfSize, -halfSize, halfSize, halfSize, -halfSize, halfSize, halfSize, halfSize, halfSize, -halfSize, halfSize, halfSize, textureScale, data.color, pos, data.rotation);
        PlanetRenderer.addCubeFacePlanet(matrix, buffer, -halfSize, -halfSize, -halfSize, -halfSize, halfSize, -halfSize, halfSize, halfSize, -halfSize, halfSize, -halfSize, -halfSize, textureScale, data.color, pos, data.rotation);
        PlanetRenderer.addCubeFacePlanet(matrix, buffer, -halfSize, -halfSize, -halfSize, -halfSize, -halfSize, halfSize, -halfSize, halfSize, halfSize, -halfSize, halfSize, -halfSize, textureScale, data.color, pos, data.rotation);
        PlanetRenderer.addCubeFacePlanet(matrix, buffer, halfSize, -halfSize, -halfSize, halfSize, halfSize, -halfSize, halfSize, halfSize, halfSize, halfSize, -halfSize, halfSize, textureScale, data.color, pos, data.rotation);
        PlanetRenderer.addCubeFacePlanet(matrix, buffer, -halfSize, -halfSize, -halfSize, halfSize, -halfSize, -halfSize, halfSize, -halfSize, halfSize, -halfSize, -halfSize, halfSize, textureScale, data.color, pos, data.rotation);
        PlanetRenderer.addCubeFacePlanet(matrix, buffer, -halfSize, halfSize, -halfSize, -halfSize, halfSize, halfSize, halfSize, halfSize, halfSize, halfSize, halfSize, -halfSize, textureScale, data.color, pos, data.rotation);
    }

    private static void addCubeFacePlanet(Matrix4f matrix, VertexConsumer buffer, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, int textureScale, float color, Vector3d planetPos, Vector3d planetRot) {
        int[] rgb = PlanetData.floatToRgb(color);
        int r = rgb[0];
        int g = rgb[1];
        int b = rgb[2];
        Vector3d lightDir = new Vector3d(-planetPos.x, -planetPos.y, -planetPos.z).normalize();
        Quaternionf rotation = new Quaternionf().rotationXYZ((float)planetRot.x, (float)planetRot.y, (float)planetRot.z);
        PlanetRenderer.addVertexWithLighting(matrix, buffer, x1, y1, z1, r, g, b, textureScale, lightDir, rotation);
        PlanetRenderer.addVertexWithLighting(matrix, buffer, x2, y2, z2, r, g, b, textureScale, lightDir, rotation);
        PlanetRenderer.addVertexWithLighting(matrix, buffer, x3, y3, z3, r, g, b, textureScale, lightDir, rotation);
        PlanetRenderer.addVertexWithLighting(matrix, buffer, x4, y4, z4, r, g, b, textureScale, lightDir, rotation);
    }

    private static void addVertexWithLighting(Matrix4f matrix, VertexConsumer buffer, float x, float y, float z, int r, int g, int b, int textureScale, Vector3d lightDir, Quaternionf rotation) {
        Vector3f vertexNormal = new Vector3f(x, y, z).normalize();
        rotation.transform(vertexNormal);
        Vector3d worldNormal = new Vector3d((double)vertexNormal.x, (double)vertexNormal.y, (double)vertexNormal.z);
        float lighting = (float)Math.max(0.0, worldNormal.dot((Vector3dc)lightDir));
        int litR = (int)((float)r * lighting);
        int litG = (int)((float)g * lighting);
        int litB = (int)((float)b * lighting);
        buffer.m_252986_(matrix, x, y, z).m_6122_(litR, litG, litB, textureScale).m_7421_((x < 0.0f ? 0.0f : 0.25f) + (y < 0.0f ? 0.0f : 0.5f), z < 0.0f ? 0.0f : 1.0f).m_5752_();
    }
}

