/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.genesis.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypeRegistry;
import team.lodestar.lodestone.registry.client.LodestoneShaderRegistry;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.StateShards;
import team.lodestar.lodestone.systems.rendering.shader.ShaderHolder;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="genesis", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ShaderRegistry {
    public static final ShaderHolder SUN_SHADER = new ShaderHolder(ResourceLocation.fromNamespaceAndPath((String)"genesis", (String)"sun"), DefaultVertexFormat.f_85817_, new String[0]);
    public static final ShaderHolder PLANET_SHADER = new ShaderHolder(ResourceLocation.fromNamespaceAndPath((String)"genesis", (String)"planet"), DefaultVertexFormat.f_85818_, new String[0]);
    public static final ShaderHolder WORMHOLE_SHADER = new ShaderHolder(ResourceLocation.fromNamespaceAndPath((String)"genesis", (String)"wormhole"), DefaultVertexFormat.f_85818_, new String[0]);
    private static LodestoneRenderType SUN_RENDER_TYPE;
    private static LodestoneRenderType PLANET_RENDER_TYPE;

    @SubscribeEvent
    public static void shaderRegistry(RegisterShadersEvent event) {
        LodestoneShaderRegistry.registerShader((RegisterShadersEvent)event, (ShaderHolder)SUN_SHADER);
        LodestoneShaderRegistry.registerShader((RegisterShadersEvent)event, (ShaderHolder)PLANET_SHADER);
        LodestoneShaderRegistry.registerShader((RegisterShadersEvent)event, (ShaderHolder)WORMHOLE_SHADER);
    }

    public static LodestoneRenderType getSunRenderType() {
        if (SUN_RENDER_TYPE == null) {
            SUN_RENDER_TYPE = LodestoneRenderTypeRegistry.createGenericRenderType((String)"sun_render_type", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (LodestoneRenderTypeRegistry.LodestoneCompositeStateBuilder)LodestoneRenderTypeRegistry.builder().setShaderState(SUN_SHADER).setTransparencyState(StateShards.NORMAL_TRANSPARENCY).setDepthTestState(new RenderStateShard.DepthTestStateShard("<=", 515)).setWriteMaskState(new RenderStateShard.WriteMaskStateShard(true, true)).setCullState(LodestoneRenderTypeRegistry.CULL));
        }
        return SUN_RENDER_TYPE;
    }

    public static LodestoneRenderType getPlanetRenderType() {
        if (PLANET_RENDER_TYPE == null) {
            PLANET_RENDER_TYPE = LodestoneRenderTypeRegistry.createGenericRenderType((String)"planet_render_type", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (LodestoneRenderTypeRegistry.LodestoneCompositeStateBuilder)LodestoneRenderTypeRegistry.builder().setShaderState(PLANET_SHADER).setTransparencyState(new RenderStateShard.TransparencyStateShard("no_transparency", RenderSystem::disableBlend, () -> {})).setDepthTestState(new RenderStateShard.DepthTestStateShard("<=", 515)).setWriteMaskState(new RenderStateShard.WriteMaskStateShard(true, true)).setCullState(LodestoneRenderTypeRegistry.CULL));
        }
        return PLANET_RENDER_TYPE;
    }
}

