/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.genesis.client;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import shipwrights.genesis.client.ShaderRegistry;

public class SunRenderer {
    public static void renderSun(RenderLevelStageEvent event, VertexConsumer buffer) {
        Matrix4f matrix;
        Uniform uniform;
        PoseStack poseStack = event.getPoseStack();
        Vector3f cameraPos = new Vector3f((float)event.getCamera().m_90583_().f_82479_, (float)event.getCamera().m_90583_().f_82480_, (float)event.getCamera().m_90583_().f_82481_);
        ShaderInstance shader = (ShaderInstance)ShaderRegistry.SUN_SHADER.getInstance().get();
        if (shader != null && (uniform = shader.m_173348_("CameraPosition")) != null) {
            uniform.m_5889_(cameraPos.x, cameraPos.y, cameraPos.z);
        }
        try {
            matrix = (Matrix4f)poseStack.m_85850_().m_252922_().clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        matrix.translate((float)(-event.getCamera().m_90583_().f_82479_), (float)(-event.getCamera().m_90583_().f_82480_), (float)(-event.getCamera().m_90583_().f_82481_));
        matrix.rotate((Quaternionfc)new Quaternionf().rotationXYZ(0.0f, 0.0f, 0.0f));
        float halfSize = 720.0f;
        SunRenderer.addCubeFaceSun(matrix, buffer, -halfSize, -halfSize, halfSize, halfSize, -halfSize, halfSize, halfSize, halfSize, halfSize, -halfSize, halfSize, halfSize);
        SunRenderer.addCubeFaceSun(matrix, buffer, -halfSize, -halfSize, -halfSize, -halfSize, halfSize, -halfSize, halfSize, halfSize, -halfSize, halfSize, -halfSize, -halfSize);
        SunRenderer.addCubeFaceSun(matrix, buffer, -halfSize, -halfSize, -halfSize, -halfSize, -halfSize, halfSize, -halfSize, halfSize, halfSize, -halfSize, halfSize, -halfSize);
        SunRenderer.addCubeFaceSun(matrix, buffer, halfSize, -halfSize, -halfSize, halfSize, halfSize, -halfSize, halfSize, halfSize, halfSize, halfSize, -halfSize, halfSize);
        SunRenderer.addCubeFaceSun(matrix, buffer, -halfSize, -halfSize, -halfSize, halfSize, -halfSize, -halfSize, halfSize, -halfSize, halfSize, -halfSize, -halfSize, halfSize);
        SunRenderer.addCubeFaceSun(matrix, buffer, -halfSize, halfSize, -halfSize, -halfSize, halfSize, halfSize, halfSize, halfSize, halfSize, halfSize, halfSize, -halfSize);
    }

    private static void addCubeFaceSun(Matrix4f matrix, VertexConsumer buffer, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        buffer.m_252986_(matrix, x1, y1, z1).m_6122_((int)(255.0f * (x1 + 720.0f) / 1440.0f), (int)(255.0f * (y1 + 720.0f) / 1440.0f), (int)(255.0f * (z1 + 720.0f) / 1440.0f), 255).m_5752_();
        buffer.m_252986_(matrix, x2, y2, z2).m_6122_((int)(255.0f * (x2 + 720.0f) / 1440.0f), (int)(255.0f * (y2 + 720.0f) / 1440.0f), (int)(255.0f * (z2 + 720.0f) / 1440.0f), 255).m_5752_();
        buffer.m_252986_(matrix, x3, y3, z3).m_6122_((int)(255.0f * (x3 + 720.0f) / 1440.0f), (int)(255.0f * (y3 + 720.0f) / 1440.0f), (int)(255.0f * (z3 + 720.0f) / 1440.0f), 255).m_5752_();
        buffer.m_252986_(matrix, x4, y4, z4).m_6122_((int)(255.0f * (x4 + 720.0f) / 1440.0f), (int)(255.0f * (y4 + 720.0f) / 1440.0f), (int)(255.0f * (z4 + 720.0f) / 1440.0f), 255).m_5752_();
    }
}

