/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.genesis.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import shipwrights.genesis.GenesisMod;
import shipwrights.genesis.sound.GenesisSounds;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class WormholeAmbianceHandler {
    private static SimpleSoundInstance voidEngineStartSound = null;
    private static SimpleSoundInstance currentAmbianceSound = null;
    private static SimpleSoundInstance fadingOutSound = null;
    private static boolean wasInWormhole = false;
    private static int soundDurationTicks = 0;
    private static int currentTick = 0;
    private static int fadeOutTicksRemaining = 0;
    private static final int CROSSFADE_DURATION_TICKS = 40;
    public static BlockPos wormholeTravelPos = new BlockPos(0, 0, 0);
    public static BlockPos voidEngineStartPos = new BlockPos(0, 0, 0);

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null || minecraft.f_91074_ == null) {
            WormholeAmbianceHandler.stopAmbiance();
            wasInWormhole = false;
            currentTick = 0;
            return;
        }
        boolean isInWormhole = minecraft.f_91073_.m_46472_().m_135782_().equals((Object)GenesisMod.WORMHOLE_DIM);
        if (isInWormhole && !wasInWormhole) {
            WormholeAmbianceHandler.startAmbiance(minecraft.m_91106_());
            WormholeAmbianceHandler.playTravelSound(minecraft);
        } else if (!isInWormhole && wasInWormhole) {
            WormholeAmbianceHandler.stopAmbiance();
            WormholeAmbianceHandler.playTravelSound(minecraft);
            SimpleSoundInstance stopSound = new SimpleSoundInstance(((SoundEvent)GenesisSounds.VOID_ENGINE_STOP.get()).m_11660_(), SoundSource.BLOCKS, 1.0f, 1.0f, Minecraft.m_91087_().f_91074_.m_217043_(), false, 0, SoundInstance.Attenuation.LINEAR, (double)wormholeTravelPos.m_123341_(), (double)wormholeTravelPos.m_123342_(), (double)wormholeTravelPos.m_123343_(), true);
            minecraft.m_91106_().m_120367_((SoundInstance)stopSound);
            currentTick = 0;
        } else if (isInWormhole) {
            ++currentTick;
            if (fadeOutTicksRemaining > 0 && --fadeOutTicksRemaining == 0 && fadingOutSound != null) {
                minecraft.m_91106_().m_120399_((SoundInstance)fadingOutSound);
                fadingOutSound = null;
            }
            if (currentAmbianceSound != null && soundDurationTicks > 0 && currentTick >= soundDurationTicks - 40 && fadingOutSound == null) {
                WormholeAmbianceHandler.startCrossfade(minecraft.m_91106_());
            }
            if (currentAmbianceSound != null && !minecraft.m_91106_().m_120403_((SoundInstance)currentAmbianceSound)) {
                WormholeAmbianceHandler.startAmbiance(minecraft.m_91106_());
            }
        }
        wasInWormhole = isInWormhole;
    }

    private static void startCrossfade(SoundManager soundManager) {
        fadingOutSound = currentAmbianceSound;
        fadeOutTicksRemaining = 40;
        currentAmbianceSound = new SimpleSoundInstance(((SoundEvent)GenesisSounds.WORMHOLE_AMBIANCE.get()).m_11660_(), SoundSource.AMBIENT, 1.0f, 1.0f, Minecraft.m_91087_().f_91074_.m_217043_(), false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true);
        soundManager.m_120367_((SoundInstance)currentAmbianceSound);
        currentTick = 0;
    }

    private static void startAmbiance(SoundManager soundManager) {
        WormholeAmbianceHandler.stopAmbiance();
        currentAmbianceSound = new SimpleSoundInstance(((SoundEvent)GenesisSounds.WORMHOLE_AMBIANCE.get()).m_11660_(), SoundSource.AMBIENT, 1.0f, 1.0f, Minecraft.m_91087_().f_91074_.m_217043_(), false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true);
        soundManager.m_120367_((SoundInstance)currentAmbianceSound);
        currentTick = 0;
        soundDurationTicks = WormholeAmbianceHandler.estimateSoundDuration();
    }

    private static int estimateSoundDuration() {
        return 1900;
    }

    private static void stopAmbiance() {
        if (currentAmbianceSound != null) {
            Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)currentAmbianceSound);
            currentAmbianceSound = null;
        }
        if (fadingOutSound != null) {
            Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)fadingOutSound);
            fadingOutSound = null;
        }
    }

    private static void playTravelSound(Minecraft minecraft) {
        SimpleSoundInstance travelSound = new SimpleSoundInstance(((SoundEvent)GenesisSounds.VOID_ENGINE_TRAVEL.get()).m_11660_(), SoundSource.BLOCKS, 1.0f, 1.0f, Minecraft.m_91087_().f_91074_.m_217043_(), false, 0, SoundInstance.Attenuation.LINEAR, (double)wormholeTravelPos.m_123341_(), (double)wormholeTravelPos.m_123342_(), (double)wormholeTravelPos.m_123343_(), true);
        minecraft.m_91106_().m_120367_((SoundInstance)travelSound);
    }

    public static void playVoidEngineStart() {
        if (voidEngineStartSound == null) {
            voidEngineStartSound = new SimpleSoundInstance(((SoundEvent)GenesisSounds.VOID_ENGINE_START.get()).m_11660_(), SoundSource.BLOCKS, 0.5f, 1.0f, Minecraft.m_91087_().f_91074_.m_217043_(), false, 0, SoundInstance.Attenuation.LINEAR, 0.0, 0.0, 0.0, true);
        }
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)voidEngineStartSound);
    }

    public static void stopVoidEngineStart() {
        Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)voidEngineStartSound);
    }
}

