/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.genesis.client.blockentityRenderer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.joml.Quaterniond;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import shipwrights.genesis.GenesisMod;
import shipwrights.genesis.blockentity.NavProjectorBlockEntity;
import shipwrights.genesis.planets.PlanetData;

public class NavProjectorBlockEntityRenderer
implements BlockEntityRenderer<NavProjectorBlockEntity> {
    static final PlanetData sunData = new PlanetData(ResourceLocation.fromNamespaceAndPath((String)"genesis", (String)"sun"), null, 15.0, 10.0, 0.0, 0.0f, 1.0f, 1.0f, 1.0);

    public NavProjectorBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(NavProjectorBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        Level level = blockEntity.m_58904_();
        if (level == null) {
            return;
        }
        long ticks = level.m_46467_();
        poseStack.m_85837_(0.5, 1.5, 0.5);
        poseStack.m_85841_(0.02f, 0.02f, 0.02f);
        BlockPos pos = blockEntity.m_58899_();
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)level, (BlockPos)pos);
        boolean isOnShip = ship != null;
        Vector3d shipPos = null;
        int scale_factor = 1000;
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        blockRenderer.m_110912_(Blocks.f_50542_.m_49966_(), poseStack, bufferSource, packedLight, packedOverlay);
        poseStack.m_85837_(0.5, 0.5, 0.5);
        if (!isOnShip) {
            poseStack.m_252880_((float)(-pos.m_123341_()) / (float)scale_factor, (float)(-pos.m_123342_()) / (float)scale_factor, (float)(-pos.m_123343_()) / (float)scale_factor);
        } else {
            Quaterniond rot = ship.getTransform().getShipToWorldRotation().invert(new Quaterniond());
            poseStack.m_252781_(new Quaternionf(rot.x(), rot.y(), rot.z(), rot.w()));
            shipPos = ship.getWorldAABB().center(new Vector3d());
            ResourceLocation currentDimension = Objects.requireNonNull(blockEntity.m_58904_()).m_46472_().m_135782_();
            if (currentDimension.toString().equals(GenesisMod.WORMHOLE_DIM.toString())) {
                shipPos = shipPos.mul(32.0, new Vector3d());
            }
            poseStack.m_252880_((float)(-shipPos.x()) / (float)scale_factor, (float)(-shipPos.y()) / (float)scale_factor, (float)(-shipPos.z()) / (float)scale_factor);
        }
        for (PlanetData planet : GenesisMod.planets) {
            NavProjectorBlockEntityRenderer.renderPlanetProjection(poseStack, bufferSource, packedLight, packedOverlay, planet, isOnShip, (Vector3dc)shipPos, pos, scale_factor, blockRenderer, ticks, partialTick);
        }
        NavProjectorBlockEntityRenderer.renderPlanetProjection(poseStack, bufferSource, packedLight, packedOverlay, sunData, isOnShip, (Vector3dc)shipPos, pos, scale_factor, blockRenderer, ticks, partialTick);
        poseStack.m_85849_();
    }

    private static void renderPlanetProjection(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, PlanetData planet, boolean isOnShip, Vector3dc shipPos, BlockPos pos, int scale_factor, BlockRenderDispatcher blockRenderer, long ticks, float partialTick) {
        float scale;
        Vector3d planetPos = planet.getCurrentPos(ticks, partialTick);
        if (isOnShip) {
            Vector3d vector3d = new Vector3d(shipPos);
            Vector3d vector3d2 = new Vector3d();
            if (planetPos.sub((Vector3dc)vector3d, vector3d2).length() > 120000.0) {
                return;
            }
        } else {
            Vector3d vector3d = new Vector3d((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            Vector3d vector3d3 = new Vector3d();
            if (planetPos.sub((Vector3dc)vector3d, vector3d3).length() > 120000.0) {
                return;
            }
        }
        if ((scale = (float)(2.0 * Math.sqrt(planet.getActualSize()) / Math.sqrt(scale_factor))) > 0.0f) {
            poseStack.m_85837_(planetPos.x / (double)scale_factor, planetPos.y / (double)scale_factor, planetPos.z / (double)scale_factor);
            poseStack.m_85841_(scale, scale, scale);
            Quaternionf rot = new Quaternionf().rotateXYZ((float)planet.rotation.x, (float)planet.rotation.y, (float)planet.rotation.z);
            poseStack.m_252781_(rot);
            poseStack.m_85837_(-0.5, -0.5, -0.5);
            if (planetPos.lengthSquared() == 0.0) {
                blockRenderer.m_110912_(Blocks.f_50147_.m_49966_(), poseStack, bufferSource, packedLight, packedOverlay);
            } else {
                blockRenderer.m_110912_(Blocks.f_50203_.m_49966_(), poseStack, bufferSource, packedLight, packedOverlay);
            }
            poseStack.m_85837_(0.5, 0.5, 0.5);
            poseStack.m_252781_(rot.invert());
            poseStack.m_85841_(1.0f / scale, 1.0f / scale, 1.0f / scale);
            poseStack.m_85837_(-planetPos.x / (double)scale_factor, -planetPos.y / (double)scale_factor, -planetPos.z / (double)scale_factor);
        }
    }

    public boolean shouldRenderOffScreen(NavProjectorBlockEntity blockEntity) {
        return true;
    }

    static {
        NavProjectorBlockEntityRenderer.sunData.rotation = new Vector3d(0.0, 0.0, 0.0);
    }
}

