/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.genesis.client.blockentityRenderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import shipwrights.genesis.block.VoidCoreBlock;
import shipwrights.genesis.blockentity.VoidCoreBlockEntity;

public class VoidCoreBlockEntityRenderer
implements BlockEntityRenderer<VoidCoreBlockEntity> {
    private static final ResourceLocation PORTAL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/end_portal.png");
    private static final float PORTAL_SIZE = 0.5f;

    public VoidCoreBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(VoidCoreBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockState state = blockEntity.m_58900_();
        if (state.m_61138_((Property)VoidCoreBlock.DORMANT) && ((Boolean)state.m_61143_((Property)VoidCoreBlock.DORMANT)).booleanValue()) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        float scale = 1.0f;
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_173239_());
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        this.drawPortalFace(vertexConsumer, matrix, scale, 0.5f, 0.0f, 0.0f, 1.0f);
        this.drawPortalFace(vertexConsumer, matrix, scale, 0.5f, 0.0f, 0.0f, -1.0f);
        this.drawPortalFace(vertexConsumer, matrix, scale, 0.5f, 0.0f, 1.0f, 0.0f);
        this.drawPortalFace(vertexConsumer, matrix, scale, 0.5f, 0.0f, -1.0f, 0.0f);
        this.drawPortalFace(vertexConsumer, matrix, scale, 0.5f, 1.0f, 0.0f, 0.0f);
        this.drawPortalFace(vertexConsumer, matrix, scale, 0.5f, -1.0f, 0.0f, 0.0f);
        poseStack.m_85849_();
    }

    private void drawPortalFace(VertexConsumer consumer, Matrix4f matrix, float scale, float size, float normalX, float normalY, float normalZ) {
        PoseStack tempStack = new PoseStack();
        if (normalX != 0.0f) {
            tempStack.m_252781_(new Quaternionf().rotationY(1.5707964f));
        } else if (normalY != 0.0f) {
            tempStack.m_252781_(new Quaternionf().rotationX(1.5707964f));
        }
        Matrix4f rotatedMatrix = new Matrix4f((Matrix4fc)matrix).mul((Matrix4fc)tempStack.m_85850_().m_252922_());
        float x = size * normalX;
        float y = size * normalY;
        float z = size * normalZ;
        if (normalX > 0.0f || normalY > 0.0f || normalZ > 0.0f) {
            consumer.m_252986_(rotatedMatrix, -size, -size, x + y + z).m_6122_(0, 0, 0, 255).m_7421_(0.0f, 0.0f).m_5752_();
            consumer.m_252986_(rotatedMatrix, size, -size, x + y + z).m_6122_(0, 0, 0, 255).m_7421_(1.0f, 0.0f).m_5752_();
            consumer.m_252986_(rotatedMatrix, size, size, x + y + z).m_6122_(0, 0, 0, 255).m_7421_(1.0f, 1.0f).m_5752_();
            consumer.m_252986_(rotatedMatrix, -size, size, x + y + z).m_6122_(0, 0, 0, 255).m_7421_(0.0f, 1.0f).m_5752_();
        } else {
            consumer.m_252986_(rotatedMatrix, -size, -size, x + y + z).m_6122_(0, 0, 0, 255).m_7421_(0.0f, 0.0f).m_5752_();
            consumer.m_252986_(rotatedMatrix, -size, size, x + y + z).m_6122_(0, 0, 0, 255).m_7421_(0.0f, 1.0f).m_5752_();
            consumer.m_252986_(rotatedMatrix, size, size, x + y + z).m_6122_(0, 0, 0, 255).m_7421_(1.0f, 1.0f).m_5752_();
            consumer.m_252986_(rotatedMatrix, size, -size, x + y + z).m_6122_(0, 0, 0, 255).m_7421_(1.0f, 0.0f).m_5752_();
        }
    }

    public boolean shouldRenderOffScreen(VoidCoreBlockEntity blockEntity) {
        return false;
    }
}

