/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.genesis.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import shipwrights.genesis.GenesisMod;
import shipwrights.genesis.data.SystemConfigModel;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DataListener {
    private static final Set<String> COMPAT_MODS = Set.of("ad_astra");

    @SubscribeEvent
    public static void onServerStop(ServerStoppedEvent event) {
        GenesisMod.planets.clear();
    }

    @SubscribeEvent
    public static void onRegisterReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new Listener());
    }

    public static class Listener
    implements ResourceManagerReloadListener {
        private static final Gson GSON = new GsonBuilder().create();

        public void m_6213_(ResourceManager resourceManager) {
            Map resources = resourceManager.m_214159_("system_config", location -> true);
            if (resources.isEmpty()) {
                GenesisMod.LOGGER.warn("Could not find any system_config.json files. Skipping planet data loading.");
                return;
            }
            ModList modList = ModList.get();
            for (Map.Entry entry : resources.entrySet()) {
                ResourceLocation location2 = (ResourceLocation)entry.getKey();
                Resource resource = (Resource)entry.getValue();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.m_215507_(), StandardCharsets.UTF_8));){
                    String mod;
                    SystemConfigModel config = (SystemConfigModel)GSON.fromJson((Reader)reader, SystemConfigModel.class);
                    if (config == null || config.planets() == null) continue;
                    GenesisMod.LOGGER.info("Loading {} planets from {}", (Object)config.planets().size(), (Object)location2);
                    for (SystemConfigModel.PlanetJsonModel planet : config.planets()) {
                        mod = planet.getDimensionID().m_135827_();
                        if (!modList.isLoaded(mod) && COMPAT_MODS.contains(mod)) continue;
                        GenesisMod.registerPlanet(planet.getDimensionID(), planet.size(), planet.gravity(), planet.orbitRadius(), planet.yearLength(), planet.r(), planet.g(), planet.b());
                        GenesisMod.LOGGER.info("Registered planet from data: {}", (Object)planet.dimensionID());
                    }
                    for (SystemConfigModel.MoonJsonModel moon : config.moons()) {
                        mod = moon.getDimensionID().m_135827_();
                        if (!modList.isLoaded(mod) && COMPAT_MODS.contains(mod)) continue;
                        GenesisMod.registerMoon(moon.getDimensionID(), moon.getParentDimensionID(), moon.size(), moon.gravity(), moon.orbitRadius(), moon.yearLength(), moon.r(), moon.g(), moon.b());
                        GenesisMod.LOGGER.info("Registered moon from data: {}", (Object)moon.dimensionID());
                    }
                }
                catch (Exception e) {
                    GenesisMod.LOGGER.error("Failed to load system_config data from: {}", (Object)location2, (Object)e);
                }
            }
            GenesisMod.finalizeMoons();
        }
    }
}

