/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.genesis.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public record SystemConfigModel(List<PlanetJsonModel> planets, List<MoonJsonModel> moons) {
    public static final Codec<SystemConfigModel> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PlanetJsonModel.CODEC.listOf().fieldOf("planets").forGetter(SystemConfigModel::planets), (App)MoonJsonModel.CODEC.listOf().fieldOf("moons").forGetter(SystemConfigModel::moons)).apply((Applicative)instance, SystemConfigModel::new));

    public SystemConfigModel {
        planets = planets != null ? planets : Collections.emptyList();
        moons = moons != null ? moons : Collections.emptyList();
    }

    public record PlanetJsonModel(String dimensionID, double size, double orbitRadius, double yearLength, double gravity, float r, float g, float b) {
        public static final Codec<PlanetJsonModel> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("dimensionID").forGetter(PlanetJsonModel::dimensionID), (App)Codec.DOUBLE.fieldOf("size").forGetter(PlanetJsonModel::size), (App)Codec.DOUBLE.fieldOf("orbitRadius").forGetter(PlanetJsonModel::orbitRadius), (App)Codec.DOUBLE.fieldOf("yearLength").forGetter(PlanetJsonModel::yearLength), (App)Codec.DOUBLE.fieldOf("gravity").forGetter(PlanetJsonModel::gravity), (App)Codec.FLOAT.fieldOf("r").forGetter(PlanetJsonModel::r), (App)Codec.FLOAT.fieldOf("g").forGetter(PlanetJsonModel::g), (App)Codec.FLOAT.fieldOf("b").forGetter(PlanetJsonModel::b)).apply((Applicative)instance, PlanetJsonModel::new));

        public ResourceLocation getDimensionID() {
            return ResourceLocation.parse((String)this.dimensionID);
        }
    }

    public record MoonJsonModel(String dimensionID, String parentDimensionID, double size, double orbitRadius, double yearLength, double gravity, float r, float g, float b) {
        public static final Codec<MoonJsonModel> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("dimensionID").forGetter(MoonJsonModel::dimensionID), (App)Codec.STRING.fieldOf("parentDimensionID").forGetter(MoonJsonModel::parentDimensionID), (App)Codec.DOUBLE.fieldOf("size").forGetter(MoonJsonModel::size), (App)Codec.DOUBLE.fieldOf("orbitRadius").forGetter(MoonJsonModel::orbitRadius), (App)Codec.DOUBLE.fieldOf("yearLength").forGetter(MoonJsonModel::yearLength), (App)Codec.DOUBLE.fieldOf("gravity").forGetter(MoonJsonModel::gravity), (App)Codec.FLOAT.fieldOf("r").forGetter(MoonJsonModel::r), (App)Codec.FLOAT.fieldOf("g").forGetter(MoonJsonModel::g), (App)Codec.FLOAT.fieldOf("b").forGetter(MoonJsonModel::b)).apply((Applicative)instance, MoonJsonModel::new));

        public ResourceLocation getDimensionID() {
            return ResourceLocation.parse((String)this.dimensionID);
        }

        public ResourceLocation getParentDimensionID() {
            return ResourceLocation.parse((String)this.parentDimensionID);
        }
    }
}

