/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.genesis.event;

import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.slf4j.Logger;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import shipwrights.genesis.GenesisMod;
import shipwrights.genesis.event.PreTravelEvent;
import shipwrights.genesis.planets.PlanetData;
import shipwrights.genesis.ship.ShipLandingAttachment;
import shipwrights.genesis.teleportation.TeleportationHandler;
import shipwrights.genesis.util.PlanetUtil;
import shipwrights.genesis.util.VSUtils;

public class AtmosphericCollision {
    private static final Logger LOGGER = GenesisMod.LOGGER;
    private static final TeleportationHandler TELEPORT_HANDLER = new TeleportationHandler(null, null, false);

    public static void atmosphericCollisionTick(ServerLevel level) {
        PlanetData planet = PlanetUtil.getPlanetByDimension((ResourceKey<Level>)level.m_46472_());
        if (planet == null) {
            return;
        }
        ResourceKey<Level> targetDimension = PlanetUtil.getSpaceDimension();
        ServerLevel targetLevel = level.m_7654_().m_129880_(targetDimension);
        if (targetLevel == null) {
            return;
        }
        ResourceKey dimension = level.m_46472_();
        Vector3d planetPos = planet.getCurrentPos(level.m_46467_());
        double atmoHeight = 2048.0;
        TeleportationHandler teleportHandler = TELEPORT_HANDLER;
        teleportHandler.reset(level, targetLevel);
        for (LoadedServerShip ship : VSUtils.getLoadedShipsInLevel(level)) {
            if (ship.isStatic() || teleportHandler.hasShip((ServerShip)ship)) continue;
            Vector3dc shipPos = ship.getTransform().getPositionInWorld();
            double shipY = shipPos.y();
            ShipLandingAttachment landingAttachment = ShipLandingAttachment.get((ServerShip)ship);
            if (shipY + 10.0 < 2048.0) {
                landingAttachment.landing = false;
                continue;
            }
            if (landingAttachment.landing && shipY < 2176.0) continue;
            Vector3d targetPos = new Vector3d(0.0, planet.getActualSize() * 0.7 + 20.0, 0.0);
            Quaterniond rotation = PlanetUtil.getPlanetRotation(planet);
            rotation.transform(targetPos);
            targetPos.add(planetPos.x(), planetPos.y(), planetPos.z());
            MinecraftForge.EVENT_BUS.post((Event)new PreTravelEvent.PlanetToSpace((ResourceKey<Level>)dimension, shipPos, targetDimension, targetPos, rotation));
            LOGGER.info("[genesis]: Handling teleport {} ({}) to {} {} {} {}", new Object[]{ship.getSlug(), ship.getId(), targetDimension.m_135782_(), targetPos.x, targetPos.y, targetPos.z});
            teleportHandler.addShip((ServerShip)ship, (Vector3dc)targetPos, (Quaterniondc)rotation);
        }
        for (LoadedServerShip ship : teleportHandler.getPendingShips()) {
            ShipLandingAttachment landingAttachment = ShipLandingAttachment.get((ServerShip)ship);
            Vector3dc pos = ship.getTransform().getPositionInWorld();
            landingAttachment.setLaunching((ResourceKey<Level>)dimension, new ChunkPos(SectionPos.m_235865_((double)pos.x()), SectionPos.m_235865_((double)pos.z())));
        }
        teleportHandler.finalizeTeleport();
    }
}

