/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.genesis.event;

import java.util.HashMap;
import java.util.List;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBdc;
import org.slf4j.Logger;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import shipwrights.genesis.GenesisMod;
import shipwrights.genesis.event.PreTravelEvent;
import shipwrights.genesis.planets.PlanetData;
import shipwrights.genesis.ship.ShipLandingAttachment;
import shipwrights.genesis.teleportation.TeleportationHandler;
import shipwrights.genesis.util.PlanetUtil;
import shipwrights.genesis.util.VSUtils;

public class PlanetCollision {
    private static final Logger LOGGER = GenesisMod.LOGGER;
    private static final double OUTER_RANGE = 128.0;
    private static final double CLOSE_RANGE = 16.0;
    private static final int LANDING_ACCURACY = 8;

    public static void planetCollisionTick(ServerLevel level) {
        if (!PlanetUtil.isSpaceDimension((ResourceKey<Level>)level.m_46472_())) {
            return;
        }
        HashMap<ResourceKey, TeleportationHandler> handlers = new HashMap<ResourceKey, TeleportationHandler>();
        List<LoadedServerShip> ships = VSUtils.getLoadedShipsInLevel(level);
        ships.sort((a, b) -> {
            AABBdc aBox = a.getWorldAABB();
            AABBdc bBox = b.getWorldAABB();
            double n = (aBox.maxX() - aBox.minX()) * (aBox.maxY() - aBox.minY()) * (aBox.maxZ() - aBox.minZ()) - (bBox.maxX() - bBox.minX()) * (bBox.maxY() - bBox.minY()) * (bBox.maxZ() - bBox.minZ());
            if (n < 0.0) {
                return 1;
            }
            if (n > 0.0) {
                return -1;
            }
            return Long.compare(a.getId(), b.getId());
        });
        for (LoadedServerShip ship : ships) {
            TeleportationHandler handler;
            Vec3 shipCenter = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getWorldAABB().center(new Vector3d()));
            PlanetUtil.PlanetWithDistance nearestPlanetData = PlanetUtil.getNearestPlanet(shipCenter, level.m_46467_()).orElse(null);
            if (nearestPlanetData == null) continue;
            PlanetData planet = nearestPlanetData.planet();
            double distance = nearestPlanetData.distance();
            double closeRange = planet.getActualSize() / 8.0;
            ResourceKey targetDimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)planet.dimensionID);
            ServerLevel targetLevel = level.m_7654_().m_129880_(targetDimension);
            if (targetLevel == null || (handler = (TeleportationHandler)handlers.get(targetDimension)) != null && handler.hasShip((ServerShip)ship)) continue;
            ShipLandingAttachment landingAttachment = ShipLandingAttachment.get((ServerShip)ship);
            if (distance > planet.getActualSize()) {
                landingAttachment.launching = false;
                continue;
            }
            if (landingAttachment.launching && distance > 0.0 || !landingAttachment.frozen && ship.isStatic()) continue;
            if (!ship.isStatic() && distance <= closeRange) {
                landingAttachment.freezeShip(ship);
            }
            ChunkPos landingChunkPos = new ChunkPos(level.f_46441_.m_188503_(17) - 8, level.f_46441_.m_188503_(17) - 8);
            Vector3d newPos = new Vector3d((double)SectionPos.m_123223_((int)landingChunkPos.f_45578_), 1440.0, (double)SectionPos.m_123223_((int)landingChunkPos.f_45579_));
            Vector3d planetPos = planet.getCurrentPos(level.m_46467_());
            Vector3d directionToPlanet = new Vector3d(shipCenter.f_82479_ - planetPos.x(), shipCenter.f_82480_ - planetPos.y(), shipCenter.f_82481_ - planetPos.z()).normalize();
            Quaterniond rotation = new Quaterniond().rotateTo((Vector3dc)new Vector3d(0.0, 1.0, 0.0), (Vector3dc)directionToPlanet);
            Quaterniond planetRotation = PlanetUtil.getPlanetRotation(planet);
            planetRotation.mul((Quaterniondc)rotation, rotation).conjugate();
            MinecraftForge.EVENT_BUS.post((Event)new PreTravelEvent.SpaceToPlanet((ResourceKey<Level>)level.m_46472_(), ship.getTransform().getPositionInWorld(), (ResourceKey<Level>)targetDimension, newPos, rotation));
            LOGGER.info("[genesis]: Handling teleport {} ({}) to {} {} {} {}", new Object[]{ship.getSlug(), ship.getId(), targetDimension.m_135782_(), newPos.x, newPos.y, newPos.z});
            TeleportationHandler handler2 = handlers.computeIfAbsent(targetDimension, targetDim1 -> new TeleportationHandler(level, targetLevel, true));
            handler2.addShip((ServerShip)ship, (Vector3dc)newPos, (Quaterniondc)rotation);
        }
        for (TeleportationHandler handler : handlers.values()) {
            for (LoadedServerShip ship : handler.getPendingShips()) {
                ShipLandingAttachment attachment = ShipLandingAttachment.get((ServerShip)ship);
                attachment.frozen = false;
                attachment.setLanding();
            }
            handler.finalizeTeleport();
        }
    }
}

