/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.genesis.event;

import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Event;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class PreTravelEvent
extends Event {
    private final ResourceKey<Level> oldLevel;
    private final Vector3dc oldPos;
    private final ResourceKey<Level> newLevel;
    private final Vector3d newPos;
    private final Quaterniond rotation;

    public PreTravelEvent(ResourceKey<Level> oldLevel, Vector3dc oldPos, ResourceKey<Level> newLevel, Vector3d newPos, Quaterniond rotation) {
        this.oldLevel = oldLevel;
        this.oldPos = oldPos;
        this.newLevel = newLevel;
        this.newPos = newPos;
        this.rotation = rotation;
    }

    public final ResourceKey<Level> getOldLevel() {
        return this.oldLevel;
    }

    public final Vector3dc getOldPosition() {
        return this.oldPos;
    }

    public final ResourceKey<Level> getNewLevel() {
        return this.newLevel;
    }

    public final Vector3dc getNewPosition() {
        return this.newPos;
    }

    public final void setNewPosition(Vector3dc newPos) {
        this.newPos.set(newPos);
    }

    public final Quaterniondc getRelativeRotation() {
        return this.rotation;
    }

    public final void setRelativeRotation(Quaterniondc rotation) {
        this.rotation.set(rotation);
    }

    public static class SpaceToPlanet
    extends PreTravelEvent {
        public SpaceToPlanet(ResourceKey<Level> oldLevel, Vector3dc oldPos, ResourceKey<Level> newLevel, Vector3d newPos, Quaterniond rotation) {
            super(oldLevel, oldPos, newLevel, newPos, rotation);
        }

        public final ResourceKey<Level> getPlanet() {
            return this.getNewLevel();
        }

        public final ResourceKey<Level> getSpace() {
            return this.getOldLevel();
        }
    }

    public static class PlanetToSpace
    extends PreTravelEvent {
        public PlanetToSpace(ResourceKey<Level> oldLevel, Vector3dc oldPos, ResourceKey<Level> newLevel, Vector3d newPos, Quaterniond rotation) {
            super(oldLevel, oldPos, newLevel, newPos, rotation);
        }

        public final ResourceKey<Level> getPlanet() {
            return this.getOldLevel();
        }

        public final ResourceKey<Level> getSpace() {
            return this.getNewLevel();
        }
    }
}

