/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.genesis.mixin;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.EntityDragger;
import org.valkyrienskies.mod.common.util.EntityDraggingInformation;
import org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import shipwrights.genesis.GenesisMod;

@Mixin(value={EntityDragger.class})
public class EntityDraggerMixin {
    @Inject(method={"dragEntitiesWithShips"}, at={@At(value="HEAD")}, remap=false)
    private void onDragEntitiesWithShips(Iterable<Entity> entities, CallbackInfo ci) {
        entities.forEach(entity -> {
            Ship ship;
            EntityDraggingInformation info = ((IEntityDraggingInformationProvider)entity).getDraggingInformation();
            Level level = entity.m_9236_();
            Long lastShip = info.getLastShipStoodOn();
            if (lastShip != null && info.getTicksSinceStoodOnShip() < 5 && GenesisMod.shouldCancelVoidDamage(level) && (ship = VSGameUtilsKt.getShipObjectWorld((Level)level).getAllShips().getById(lastShip.longValue())) != null && ship.getWorldAABB().containsPoint((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)entity.m_20182_()))) {
                info.setTicksSinceStoodOnShip(0);
            }
        });
    }
}

