/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.genesis.mixin;

import com.bawnorton.mixinsquared.TargetHandler;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.joml.primitives.AABBi;
import org.joml.primitives.AABBic;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.util.AABBdUtilKt;
import org.valkyrienskies.core.util.VectorConversionsKt;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Mixin(value={ClientLevel.class}, priority=1500)
public class VSClientLevelMixin {
    @Unique
    private final RandomSource genesis$vsRandom = RandomSource.m_216327_();
    @Shadow
    @Final
    private Minecraft f_104565_;

    @Shadow
    private void m_104689_(BlockPos blockPos, BlockState blockState, ParticleOptions particleOptions, boolean bl2) {
    }

    @TargetHandler(mixin="org.valkyrienskies.mod.mixin.client.world.MixinClientLevel", name="afterAnimatedTick")
    @WrapMethod(method={"@MixinSquared:Handler"})
    private void genesis$tickFewerBlocksOnMiniShips(int posX, int posY, int posZ, CallbackInfo ci, Operation<Void> original) {
        boolean holdingBarrierItem = false;
        if (this.f_104565_.f_91072_.m_105295_() == GameType.CREATIVE) {
            for (ItemStack itemStack : this.f_104565_.f_91074_.m_6167_()) {
                if (itemStack.m_41720_() != Blocks.f_50375_.m_5456_()) continue;
                holdingBarrierItem = true;
                break;
            }
        }
        Vec3 pos = this.f_104565_.f_91074_.m_20182_();
        AABBd origin = new AABBd(pos.f_82479_, pos.f_82480_, pos.f_82481_, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        AABBd shipIntersectBB = AABBdUtilKt.expand((AABBd)new AABBd((AABBdc)origin), (double)32.0);
        double biggerBBProbability = 0.0203857421875;
        double smallerBBProbability = 0.1630859375;
        AABBd temp0 = new AABBd();
        AABBi temp1 = new AABBi();
        AABBd temp2 = new AABBd();
        AABBi temp3 = new AABBi();
        AABBi temp4 = new AABBi();
        AABBi temp5 = new AABBi();
        AABBd temp6 = new AABBd();
        AABBd temp7 = new AABBd();
        for (Ship ship : VSGameUtilsKt.getShipsIntersecting((Level)((Level)ClientLevel.class.cast(this)), (AABBdc)shipIntersectBB)) {
            AABBic shipVoxelAABB = ship.getShipAABB();
            if (shipVoxelAABB == null) continue;
            double distanceScaling = ship.getTransform().getShipToWorldScaling().x();
            AABBd biggerBB = AABBdUtilKt.expand((AABBd)temp6.set((AABBdc)origin), (double)(32.0 * distanceScaling));
            AABBd smallerBB = AABBdUtilKt.expand((AABBd)temp7.set((AABBdc)origin), (double)(16.0 * distanceScaling));
            AABBi biggerBBTransformed = VectorConversionsKt.toAABBi((AABBdc)biggerBB.transform(ship.getWorldToShip(), temp0), (AABBi)temp1);
            AABBi smallerBBTransformed = VectorConversionsKt.toAABBi((AABBdc)smallerBB.transform(ship.getWorldToShip(), temp2), (AABBi)temp3);
            AABBi biggerBBIntersection = VectorConversionsKt.expand((AABBic)shipVoxelAABB, (int)1, (AABBi)temp4).intersection((AABBic)biggerBBTransformed);
            AABBi smallerBBIntersection = VectorConversionsKt.expand((AABBic)shipVoxelAABB, (int)1, (AABBi)temp5).intersection((AABBic)smallerBBTransformed);
            if (biggerBBIntersection.isValid()) {
                this.genesis$animateTickVS((AABBic)biggerBBIntersection, 0.0203857421875, holdingBarrierItem);
            }
            if (!smallerBBIntersection.isValid()) continue;
            this.genesis$animateTickVS((AABBic)smallerBBIntersection, 0.1630859375, holdingBarrierItem);
        }
    }

    @Unique
    private void genesis$animateTickVS(AABBic region, double regionBlockProbability, boolean holdingBarrierItem) {
        int volume = (region.maxX() - region.minX() + 1) * (region.maxY() - region.minY() + 1) * (region.maxZ() - region.minZ() + 1);
        double blocksToTickAsDouble = (double)volume * regionBlockProbability;
        int blocksToTick = (int)Math.floor(blocksToTickAsDouble);
        if (this.genesis$vsRandom.m_188500_() > blocksToTickAsDouble - (double)blocksToTick) {
            ++blocksToTick;
        }
        ClientLevel thisAsClientLevel = (ClientLevel)ClientLevel.class.cast(this);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int minCX = SectionPos.m_123171_((int)region.minX());
        int maxCX = SectionPos.m_123171_((int)region.maxX());
        int minCZ = SectionPos.m_123171_((int)region.minZ());
        int maxCZ = SectionPos.m_123171_((int)region.maxZ());
        LevelChunk[][] chunkCache = new LevelChunk[maxCX - minCX + 1][maxCZ - minCZ + 1];
        for (int i = 0; i < blocksToTick; ++i) {
            int cz;
            int posX = region.minX() + this.genesis$vsRandom.m_188503_(region.maxX() - region.minX() + 1);
            int posY = region.minY() + this.genesis$vsRandom.m_188503_(region.maxY() - region.minY() + 1);
            int posZ = region.minZ() + this.genesis$vsRandom.m_188503_(region.maxZ() - region.minZ() + 1);
            mutableBlockPos.m_122178_(posX, posY, posZ);
            if (thisAsClientLevel.m_151570_((BlockPos)mutableBlockPos)) continue;
            int cx = SectionPos.m_123171_((int)posX) - minCX;
            LevelChunk levelChunk = chunkCache[cx][cz = SectionPos.m_123171_((int)posZ) - minCZ];
            if (levelChunk == null) {
                chunkCache[cx][cz] = levelChunk = thisAsClientLevel.m_6325_(cx + minCX, cz + minCZ);
            }
            BlockState blockState = levelChunk.m_8055_((BlockPos)mutableBlockPos);
            blockState.m_60734_().m_214162_(blockState, (Level)thisAsClientLevel, (BlockPos)mutableBlockPos, this.genesis$vsRandom);
            FluidState fluidState = levelChunk.m_6425_((BlockPos)mutableBlockPos);
            if (!fluidState.m_76178_()) {
                fluidState.m_230558_((Level)thisAsClientLevel, (BlockPos)mutableBlockPos, this.genesis$vsRandom);
                ParticleOptions particleOptions = fluidState.m_76189_();
                if (particleOptions != null && this.genesis$vsRandom.m_188503_(10) == 0) {
                    boolean bl2 = blockState.m_60783_((BlockGetter)thisAsClientLevel, (BlockPos)mutableBlockPos, Direction.DOWN);
                    BlockPos blockPos = mutableBlockPos.m_7495_();
                    if (!thisAsClientLevel.m_151570_(blockPos)) {
                        this.m_104689_(blockPos, levelChunk.m_8055_(blockPos), particleOptions, bl2);
                    }
                }
            }
            if (!holdingBarrierItem || !blockState.m_60713_(Blocks.f_50375_)) continue;
            thisAsClientLevel.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_194652_, blockState), (double)posX + 0.5, (double)posY + 0.5, (double)posZ + 0.5, 0.0, 0.0, 0.0);
        }
    }
}

