/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.genesis.mixin.dataplanets;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import shipwrights.dataplanets.MutableTags;
import shipwrights.dataplanets.PlanetLookup;
import shipwrights.dataplanets.items.SpaceArmourItem;
import shipwrights.dataplanets.systemCreation.PlanetData;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Unique
    private static final UUID dataplanets$lowGravity = UUID.randomUUID();

    @Shadow
    @Nullable
    public abstract AttributeInstance m_21051_(Attribute var1);

    @Unique
    private static boolean dataplanets$shouldBurn(double temperature) {
        return temperature > 1.6;
    }

    @Unique
    private static boolean dataplanets$shouldFreeze(double temperature) {
        return temperature < 0.4;
    }

    @Unique
    private static boolean dataplanets$shouldSuffocate(double atmosphericDensity) {
        return atmosphericDensity < 0.4;
    }

    public LivingEntityMixin(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    @Inject(method={"equipmentHasChanged"}, at={@At(value="TAIL")})
    private void equip(ItemStack oldItem, ItemStack newItem, CallbackInfoReturnable<Boolean> cir) {
        if (oldItem.m_204117_(MutableTags.PROVIDES_OXYGEN)) {
            this.m_20137_("has_oxygen");
        }
        if (newItem.m_204117_(MutableTags.PROVIDES_OXYGEN)) {
            this.m_20049_("has_oxygen");
        }
        if (oldItem.m_41720_() instanceof SpaceArmourItem) {
            if (SpaceArmourItem.hasModule(oldItem, "heat")) {
                this.m_20137_("has_heat");
            }
            if (SpaceArmourItem.hasModule(newItem, "heat")) {
                this.m_20049_("has_heat");
            }
            if (SpaceArmourItem.hasModule(oldItem, "cooling")) {
                this.m_20137_("has_cooling");
            }
            if (SpaceArmourItem.hasModule(newItem, "cooling")) {
                this.m_20049_("has_cooling");
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void checkKey(CallbackInfo ci) {
        AttributeInstance gravity = this.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
        if (this.m_9236_().m_46472_().m_135782_().m_135827_().equals("dataplanets")) {
            Player player;
            boolean creative;
            ResourceLocation dimension = this.m_9236_().m_46472_().m_135782_();
            PlanetData planetData = PlanetLookup.get(dimension);
            if (gravity != null) {
                double mult = planetData.gravity() - 1.0;
                AttributeModifier modifierNew = new AttributeModifier(dataplanets$lowGravity, "Low Gravity", mult, AttributeModifier.Operation.MULTIPLY_TOTAL);
                AttributeModifier modifierOld = gravity.m_22111_(dataplanets$lowGravity);
                if (modifierOld == null || modifierOld.m_22218_() != modifierNew.m_22218_()) {
                    gravity.m_22120_(dataplanets$lowGravity);
                    gravity.m_22125_(modifierNew);
                }
            }
            MinecraftServer server = this.m_20194_();
            LivingEntity livingEntity = (LivingEntity)this;
            boolean bl = creative = livingEntity instanceof Player && (player = (Player)livingEntity).m_7500_();
            if (!this.m_9236_().f_46443_ && server != null && !creative) {
                if (LivingEntityMixin.dataplanets$shouldSuffocate(planetData.atmosphericDensity())) {
                    if (this.m_19880_().contains("in_oxygen_bubble")) {
                        this.m_20137_("in_oxygen_bubble");
                    } else if (!this.m_19880_().contains("has_oxygen")) {
                        this.m_6469_(this.m_269291_().m_269063_(), 1.0f);
                    }
                }
                if (LivingEntityMixin.dataplanets$shouldFreeze(planetData.temperature()) && !this.m_19880_().contains("has_heat")) {
                    this.m_146917_(200);
                }
                if (LivingEntityMixin.dataplanets$shouldBurn(planetData.temperature()) && !this.m_19880_().contains("has_cooling")) {
                    this.m_7311_(20);
                }
            }
        } else if (gravity != null) {
            gravity.m_22120_(dataplanets$lowGravity);
        }
    }
}

