/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.genesis.planets;

import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import shipwrights.genesis.data.SystemConfigModel;

public class PlanetData {
    @Nullable
    public final PlanetData parent;
    public final ResourceLocation dimensionID;
    public final double orbitRadius;
    private final double orbitalTheta;
    private final double orbitalPhi;
    private final double orbitalPeriod;
    public Vector3d rotation;
    private final double size;
    public final float color;
    public final double gravity;
    public final int hash;

    public PlanetData(ResourceLocation dimensionID, @Nullable PlanetData parent, double size, double orbitRadius, double yearLength, float r, float g, float b, double gravity) {
        int hash = dimensionID.toString().hashCode();
        Random rand = new Random(hash);
        this.parent = parent;
        this.dimensionID = dimensionID;
        this.orbitRadius = orbitRadius;
        this.rotation = new Vector3d(rand.nextDouble(), rand.nextDouble(), rand.nextDouble());
        this.size = size;
        this.orbitalPeriod = yearLength;
        this.color = PlanetData.rgbToFloat(r, g, b);
        this.gravity = gravity;
        this.hash = dimensionID.hashCode();
        for (int i = 0; i < rand.nextInt(2, 20); ++i) {
            rand.nextDouble();
        }
        this.orbitalTheta = rand.nextDouble() * 2.0 * Math.PI;
        this.orbitalPhi = (Math.acos(2.0 * rand.nextDouble() - 1.0) + Math.PI) / 3.0;
    }

    public Vector3d getCurrentPos(long ticks, float subticks) {
        if (this.getYearLengthTicks() == 0 || this.orbitRadius == 0.0) {
            if (this.parent != null) {
                return this.parent.getCurrentPos(ticks, subticks);
            }
            return new Vector3d(0.0, 0.0, 0.0);
        }
        Vector3d out = new Vector3d(1.0, 0.0, 0.0);
        out = out.rotateY(Math.PI * 2 * (double)((float)ticks + subticks) / (double)this.getYearLengthTicks());
        out = out.rotateY(this.orbitalTheta);
        out = out.rotateX(this.orbitalPhi + 1.5707963267948966);
        out.normalize(this.orbitRadius * 15000.0);
        if (this.parent != null) {
            out = out.add((Vector3dc)this.parent.getCurrentPos(ticks, subticks), new Vector3d());
        }
        return out;
    }

    public Vector3d getCurrentPos(long ticks) {
        return this.getCurrentPos(ticks, 0.0f);
    }

    public static float rgbToFloat(float r, float g, float b) {
        int ri = (int)(r * 255.0f) & 0xFF;
        int gi = (int)(g * 255.0f) & 0xFF;
        int bi = (int)(b * 255.0f) & 0xFF;
        int packed = ri << 16 | gi << 8 | bi;
        return Float.intBitsToFloat(packed);
    }

    public static int[] floatToRgb(float packedFloat) {
        int packed = Float.floatToIntBits(packedFloat);
        int r = packed >> 16 & 0xFF;
        int g = packed >> 8 & 0xFF;
        int b = packed & 0xFF;
        return new int[]{r, g, b};
    }

    public String toString() {
        return "PlanetData{dimensionID=" + this.dimensionID + "}";
    }

    public int getYearLengthTicks() {
        return (int)(this.orbitalPeriod * 4608000.0);
    }

    public double getActualSize() {
        return this.size * 96.0;
    }

    public SystemConfigModel.PlanetJsonModel toJsonModel() {
        int[] color = PlanetData.floatToRgb(this.color);
        return new SystemConfigModel.PlanetJsonModel(this.dimensionID.toString(), this.size, this.orbitRadius, this.orbitalPeriod, this.gravity, color[0], color[1], color[2]);
    }
}

