/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.genesis.util;

import java.util.Comparator;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaterniond;
import org.joml.Vector3d;
import shipwrights.genesis.GenesisMod;
import shipwrights.genesis.planets.PlanetData;

public class PlanetUtil {
    public static ResourceKey<Level> getSpaceDimension() {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)GenesisMod.SPACE_DIM);
    }

    public static boolean isSpaceDimension(ResourceKey<Level> dimension) {
        return dimension.m_135782_().equals((Object)GenesisMod.SPACE_DIM);
    }

    @Nullable
    public static PlanetData getPlanetByDimension(ResourceKey<Level> dimension) {
        ResourceLocation dimLocation = dimension.m_135782_();
        return GenesisMod.planets.stream().filter(planet -> planet.dimensionID.equals((Object)dimLocation)).findFirst().orElse(null);
    }

    public static Optional<PlanetWithDistance> getNearestPlanet(Vec3 position, long ticks) {
        return GenesisMod.planets.stream().map(planet -> {
            Vector3d planetPos = planet.getCurrentPos(ticks);
            double distance = Math.sqrt(Math.pow(position.f_82479_ - planetPos.x, 2.0) + Math.pow(position.f_82480_ - planetPos.y, 2.0) + Math.pow(position.f_82481_ - planetPos.z, 2.0));
            return new PlanetWithDistance((PlanetData)planet, distance);
        }).min(Comparator.comparingDouble(pwd -> pwd.distance)).filter(pwd -> pwd.distance < Double.MAX_VALUE);
    }

    public static Quaterniond getPlanetRotation(PlanetData planet) {
        return new Quaterniond();
    }

    public record PlanetWithDistance(PlanetData planet, double distance) {
    }
}

