/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.genesis.worldgen;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.jetbrains.annotations.NotNull;
import shipwrights.genesis.GenesisBlocks;
import shipwrights.genesis.block.AsteroidBlock;

public class AsteroidBlockSurfaceRule
implements SurfaceRules.RuleSource {
    public static final KeyDispatchDataCodec<AsteroidBlockSurfaceRule> CODEC = KeyDispatchDataCodec.m_216238_((MapCodec)MapCodec.unit((Object)new AsteroidBlockSurfaceRule()));
    private static List<BlockState> states;

    AsteroidBlockSurfaceRule() {
    }

    @NotNull
    public KeyDispatchDataCodec<? extends SurfaceRules.RuleSource> m_213795_() {
        return CODEC;
    }

    public SurfaceRules.SurfaceRule apply(SurfaceRules.Context arg) {
        return (i, j, k) -> {
            int index = (int)(this.hash3(i, j, k) % (long)AsteroidBlockSurfaceRule.getStates().size());
            return AsteroidBlockSurfaceRule.getStates().get(index);
        };
    }

    private long hash3(int x, int y, int z) {
        long h = (long)x * 73428767L ^ (long)y * 91278311L ^ (long)z * 37855139L;
        h = (h ^ h >>> 13) * 1274126177L;
        h ^= h >>> 16;
        return Math.abs(h);
    }

    private static List<BlockState> getStates() {
        if (states == null) {
            states = AsteroidBlockSurfaceRule.buildStates();
        }
        return states;
    }

    private static List<BlockState> buildStates() {
        ArrayList<BlockState> result = new ArrayList<BlockState>();
        BlockState baseState = ((Block)GenesisBlocks.ASTEROID_0.get()).m_49966_();
        int maxVariant = AsteroidBlock.VARIANT.m_6908_().stream().mapToInt(Integer::intValue).max().orElse(0);
        int maxPalette = AsteroidBlock.PALETTE.m_6908_().stream().mapToInt(Integer::intValue).max().orElse(0);
        for (int palette = 0; palette <= maxPalette; ++palette) {
            for (int variant = 0; variant <= maxVariant; ++variant) {
                result.add((BlockState)((BlockState)baseState.m_61124_((Property)AsteroidBlock.VARIANT, (Comparable)Integer.valueOf(variant))).m_61124_((Property)AsteroidBlock.PALETTE, (Comparable)Integer.valueOf(palette)));
            }
        }
        return result;
    }
}

