/*
 * Decompiled with CFR 0.152.
 */
package shipwrights.genesis.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.jetbrains.annotations.NotNull;

public class RandomNoise
implements DensityFunction {
    public static final MapCodec<RandomNoise> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.fieldOf("scale").forGetter(r -> r.scale), (App)DensityFunction.f_208217_.fieldOf("frequency").forGetter(r -> r.frequency)).apply((Applicative)instance, RandomNoise::new));
    public static final KeyDispatchDataCodec<RandomNoise> KEY_CODEC = KeyDispatchDataCodec.m_216238_(MAP_CODEC);
    private final double scale;
    private final Holder<DensityFunction> frequency;

    public RandomNoise(double scale, Holder<DensityFunction> frequency) {
        this.scale = scale;
        this.frequency = frequency;
    }

    public double m_207386_(@NotNull DensityFunction.FunctionContext context) {
        double frequency = ((DensityFunction)this.frequency.m_203334_()).m_207386_(context) / 4.0;
        int x = context.m_207115_();
        int y = context.m_207114_();
        int z = context.m_207113_();
        double center = this.getNoise(x, y, z);
        double scale = 1.0;
        if (this.getNoise(x + 25320, y * 4 - 3453, z * 2 + 534) > frequency) {
            return 0.0;
        }
        if (center < this.getNoise(x + 1, y, z)) {
            return 0.0;
        }
        if (center < this.getNoise(x - 1, y, z)) {
            return 0.0;
        }
        if (center < this.getNoise(x, y + 1, z)) {
            return 0.0;
        }
        if (center < this.getNoise(x, y - 1, z)) {
            return 0.0;
        }
        if (center < this.getNoise(x, y, z + 1)) {
            return 0.0;
        }
        if (center < this.getNoise(x, y, z - 1)) {
            return 0.0;
        }
        double scaled = center * scale;
        return scaled > 0.1 ? scaled : 0.0;
    }

    private double getNoise(int x, int y, int z) {
        long seed = (long)x * 3129871L ^ (long)z * 116129781L ^ (long)y * 42317861L;
        seed = seed * seed * 42317861L + seed * 11L;
        seed ^= seed >>> 13;
        seed *= 25214903917L;
        seed ^= seed >>> 17;
        return (double)(seed & 0xFFFFFFFL) / 2.68435455E8;
    }

    private long getSeed(int x, int y, int z) {
        return (long)x * 341873128712L + (long)y * 132897987541L + (long)z * 42317861L;
    }

    public void m_207362_(double[] arr, DensityFunction.ContextProvider provider) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.m_207386_(provider.m_207263_(i));
        }
    }

    public DensityFunction m_207456_(DensityFunction.Visitor visitor) {
        return this;
    }

    public double m_207402_() {
        return -this.scale;
    }

    public double m_207401_() {
        return this.scale;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return KEY_CODEC;
    }
}

