/*
 * Decompiled with CFR 0.152.
 */
package dev.spagurder.htn;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import dev.spagurder.htn.Config;
import dev.spagurder.htn.data.HTNState;
import dev.spagurder.htn.data.PlayerData;
import java.time.Instant;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class HTNCommands {
    private static void sendKV(CommandSourceStack source, String label, String value) {
        String line = String.format("\u00a7e%-20s \u00a7r%s", label, value);
        source.sendSuccess(() -> Component.literal((String)line), false);
    }

    public static int showPlayerInsights(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (!source.isPlayer()) {
            source.sendFailure((Component)Component.literal((String)"This command can only be run by a player!"));
            return 0;
        }
        ServerPlayer player = source.getPlayer();
        if (player == null) {
            source.sendFailure((Component)Component.literal((String)"Player is null!"));
            return 0;
        }
        PlayerData playerData = HTNState.playerState.get(player.getUUID());
        if (playerData == null) {
            source.sendFailure((Component)Component.literal((String)"Player data doesn't exist!"));
            return 0;
        }
        source.sendSuccess(() -> Component.literal((String)"\u00a76\u00a7l=== Hardcore Totem Nerf ==="), false);
        if (Config.useCooldown) {
            HTNCommands.sendKV(source, "Cooldown", Config.usageCooldown + "s");
            long currentTime = Instant.now().getEpochSecond();
            long cooldownRemaining = Math.max((long)Config.usageCooldown - (currentTime - playerData.totemLastUsed), 0L);
            if (cooldownRemaining > 0L) {
                HTNCommands.sendKV(source, "Cooldown Remaining", cooldownRemaining + "s");
            } else {
                HTNCommands.sendKV(source, "Cooldown Remaining", "\u00a77N/A");
            }
        } else {
            HTNCommands.sendKV(source, "Cooldown", "\u00a77N/A");
        }
        source.sendSuccess(() -> Component.literal((String)"\u00a77--------------------------"), false);
        if (Config.useUsageLimit) {
            HTNCommands.sendKV(source, "Usage Limit", String.valueOf(Config.usageLimit));
            HTNCommands.sendKV(source, "Uses Remaining", String.valueOf(Math.max(Config.usageLimit - playerData.totemUsages, 0)));
        }
        HTNCommands.sendKV(source, "Totems Used", String.valueOf(playerData.totemUsages));
        return 1;
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder base = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"hardcoretotemnerf").requires(source -> Config.allowPlayerInsights)).then(Commands.literal((String)"insights").executes(HTNCommands::showPlayerInsights));
        LiteralArgumentBuilder alias = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"htn").requires(source -> Config.allowPlayerInsights)).redirect((CommandNode)base.build());
        dispatcher.register(base);
        dispatcher.register(alias);
    }
}

