/*
 * Decompiled with CFR 0.152.
 */
package dev.spagurder.htn.data;

import com.google.gson.Gson;
import dev.spagurder.htn.HardcoreTotemNerf;
import dev.spagurder.htn.data.PlayerData;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.UUID;

public class HTNState {
    public static final HashMap<UUID, PlayerData> playerState = new HashMap();
    private static final Gson GSON = new Gson();

    public static void unloadAndSavePlayerData(UUID uuid) {
        HTNState.savePlayerData(playerState.remove(uuid), uuid);
    }

    public static void savePlayerData(UUID uuid) {
        HTNState.savePlayerData(playerState.get(uuid), uuid);
    }

    public static void savePlayerData(PlayerData playerData, UUID uuid) {
        if (playerData == null) {
            HardcoreTotemNerf.LOGGER.error("Player missing during save: {}", (Object)uuid);
            return;
        }
        Path dataFile = HTNState.getPlayerDataPath(uuid);
        if (dataFile == null) {
            return;
        }
        try (FileWriter writer = new FileWriter(dataFile.toFile());){
            GSON.toJson((Object)playerData, (Appendable)writer);
        }
        catch (IOException e) {
            HardcoreTotemNerf.LOGGER.error("Failed to save player data: {}", (Object)uuid);
            HardcoreTotemNerf.LOGGER.error(e.getMessage());
        }
    }

    public static void loadPlayerData(UUID uuid) {
        Path dataFile = HTNState.getPlayerDataPath(uuid);
        if (dataFile != null && dataFile.toFile().exists()) {
            try (FileReader reader = new FileReader(dataFile.toFile());){
                playerState.put(uuid, (PlayerData)GSON.fromJson((Reader)reader, PlayerData.class));
                HardcoreTotemNerf.LOGGER.info("Player data loaded: {}", (Object)uuid);
                return;
            }
            catch (IOException e) {
                HardcoreTotemNerf.LOGGER.error("Failed to load player data: {}", (Object)uuid);
                HardcoreTotemNerf.LOGGER.error(e.getMessage());
            }
        }
        HardcoreTotemNerf.LOGGER.info("Creating new player data: {}", (Object)uuid);
        playerState.put(uuid, new PlayerData(uuid));
    }

    private static Path getPlayerDataPath(UUID uuid) {
        Path dataFile = Paths.get("hardcoretotemnerf", uuid.toString() + ".json");
        try {
            Files.createDirectories(dataFile.getParent(), new FileAttribute[0]);
            return dataFile;
        }
        catch (IOException e) {
            HardcoreTotemNerf.LOGGER.error("Failed to create data folder");
            HardcoreTotemNerf.LOGGER.error(e.getMessage());
            return null;
        }
    }
}

