package dev.spagurder.htn;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import dev.spagurder.htn.data.HTNState;
import dev.spagurder.htn.data.PlayerData;
import java.time.Instant;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

import static net.minecraft.class_2170.method_9247;

public class HTNCommands {

    private static void sendKV(class_2168 source, String label, String value) {
        String line = String.format("§e%-20s §r%s", label, value);
        source.method_9226(() -> class_2561.method_43470(line), false);
    }

    public static int showPlayerInsights(CommandContext<class_2168> ctx) {
        class_2168 source = ctx.getSource();
        if (!source.method_43737()) {
            source.method_9213(class_2561.method_43470("This command can only be run by a player!"));
            return 0;
        }
        class_3222 player = source.method_44023();
        if (player == null) {
            source.method_9213(class_2561.method_43470("Player is null!"));
            return 0;
        }
        PlayerData playerData = HTNState.playerState.get(player.method_5667());
        if  (playerData == null) {
            source.method_9213(class_2561.method_43470("Player data doesn't exist!"));
            return 0;
        }

        source.method_9226(() -> class_2561.method_43470("§6§l=== Hardcore Totem Nerf ==="), false);

        if (Config.useCooldown) {
            sendKV(source, "Cooldown", Config.usageCooldown + "s");
            long currentTime = Instant.now().getEpochSecond();
            long cooldownRemaining = Math.max(Config.usageCooldown - (currentTime - playerData.totemLastUsed), 0);
            if  (cooldownRemaining > 0) {
                sendKV(source, "Cooldown Remaining", cooldownRemaining + "s");
            } else {
                sendKV(source, "Cooldown Remaining", "§7N/A");
            }
        } else {
            sendKV(source, "Cooldown", "§7N/A");
        }

        source.method_9226(() -> class_2561.method_43470("§7--------------------------"), false);

        if (Config.useUsageLimit) {
            sendKV(source, "Usage Limit", String.valueOf(Config.usageLimit));
            sendKV(source, "Uses Remaining", String.valueOf(Math.max(Config.usageLimit - playerData.totemUsages, 0)));
        }
        sendKV(source, "Totems Used", String.valueOf(playerData.totemUsages));

        return 1;
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        var base = method_9247(HardcoreTotemNerf.MOD_ID)
                .requires(source -> Config.allowPlayerInsights)
                .then(method_9247("insights")
                        .executes(HTNCommands::showPlayerInsights)
                );
        var alias = method_9247("htn")
                .requires(source -> Config.allowPlayerInsights)
                .redirect(base.build());

        dispatcher.register(base);
        dispatcher.register(alias);
    }

}
