/*
 * Decompiled with CFR 0.152.
 */
package dev.spagurder.htn;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import dev.spagurder.htn.Config;
import dev.spagurder.htn.data.HTNState;
import dev.spagurder.htn.data.PlayerData;
import java.time.Instant;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class HTNCommands {
    private static void sendKV(class_2168 source, String label, String value) {
        String line = String.format("\u00a7e%-20s \u00a7r%s", label, value);
        source.method_9226(() -> class_2561.method_43470((String)line), false);
    }

    public static int showPlayerInsights(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be run by a player!"));
            return 0;
        }
        class_3222 player = source.method_44023();
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Player is null!"));
            return 0;
        }
        PlayerData playerData = HTNState.playerState.get(player.method_5667());
        if (playerData == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Player data doesn't exist!"));
            return 0;
        }
        source.method_9226(() -> class_2561.method_43470((String)"\u00a76\u00a7l=== Hardcore Totem Nerf ==="), false);
        if (Config.useCooldown) {
            HTNCommands.sendKV(source, "Cooldown", Config.usageCooldown + "s");
            long currentTime = Instant.now().getEpochSecond();
            long cooldownRemaining = Math.max((long)Config.usageCooldown - (currentTime - playerData.totemLastUsed), 0L);
            if (cooldownRemaining > 0L) {
                HTNCommands.sendKV(source, "Cooldown Remaining", cooldownRemaining + "s");
            } else {
                HTNCommands.sendKV(source, "Cooldown Remaining", "\u00a77N/A");
            }
        } else {
            HTNCommands.sendKV(source, "Cooldown", "\u00a77N/A");
        }
        source.method_9226(() -> class_2561.method_43470((String)"\u00a77--------------------------"), false);
        if (Config.useUsageLimit) {
            HTNCommands.sendKV(source, "Usage Limit", String.valueOf(Config.usageLimit));
            HTNCommands.sendKV(source, "Uses Remaining", String.valueOf(Math.max(Config.usageLimit - playerData.totemUsages, 0)));
        }
        HTNCommands.sendKV(source, "Totems Used", String.valueOf(playerData.totemUsages));
        return 1;
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder base = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"hardcoretotemnerf").requires(source -> Config.allowPlayerInsights)).then(class_2170.method_9247((String)"insights").executes(HTNCommands::showPlayerInsights));
        LiteralArgumentBuilder alias = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"htn").requires(source -> Config.allowPlayerInsights)).redirect((CommandNode)base.build());
        dispatcher.register(base);
        dispatcher.register(alias);
    }
}

