/*
 * Decompiled with CFR 0.152.
 */
package dev.spagurder.htn;

import dev.spagurder.htn.Config;
import dev.spagurder.htn.HTNUtil;
import dev.spagurder.htn.HardcoreTotemNerf;
import dev.spagurder.htn.data.HTNState;
import dev.spagurder.htn.data.PlayerData;
import java.time.Instant;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1324;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.server.MinecraftServer;

public class PostTotemHandler {
    public static void handlePostTotem(class_3222 player) {
        PlayerData playerData = HTNState.playerState.get(player.method_5667());
        playerData.totemLastUsed = Instant.now().getEpochSecond();
        ++playerData.totemUsages;
        if (Config.enableWarnings) {
            if (Config.useCooldown) {
                HTNUtil.sendMessage(player, "A totem cooldown of " + Config.usageCooldown + " seconds has been applied.");
            }
            if (Config.useUsageLimit) {
                HTNUtil.sendMessage(player, "You have " + (Config.usageLimit - playerData.totemUsages) + " totem usages left.");
            }
        }
        if (Config.usageReducesMaxHealth) {
            class_1324 maxHealthAttribute = player.method_5996(class_5134.field_23716);
            if (maxHealthAttribute != null) {
                float prospectiveMaxHealth = player.method_6063() - Config.maxHealthReductionAmount;
                float maxHealth = Math.max(prospectiveMaxHealth, Config.minimumMaxHealth);
                playerData.maxHealthDeficit += player.method_6063() - maxHealth;
                if (maxHealth <= 0.0f) {
                    playerData.outOfMaxHealth = true;
                    MinecraftServer server = player.method_5682();
                    if (server != null) {
                        HTNUtil.broadcastMessage(server, player.method_5477().getString() + " used too many totems.");
                        HTNUtil.broadcastMessage(server, player.method_5477().getString() + " is now incapable of living.");
                        maxHealthAttribute.method_6192(1.0);
                        player.method_6012();
                        server.execute(() -> {
                            if (!player.method_29504()) {
                                player.method_5643(player.method_48923().method_48830(), Float.MAX_VALUE);
                            }
                        });
                    } else {
                        HardcoreTotemNerf.LOGGER.error("Unable to get server instance");
                    }
                    return;
                }
                maxHealthAttribute.method_6192((double)maxHealth);
                player.method_6033(Math.min(player.method_6032(), maxHealth));
            } else {
                HardcoreTotemNerf.LOGGER.error("MAX_HEALTH attribute missing from player {}", (Object)player.method_5667());
            }
        }
        if (Config.disableAbsorption) {
            player.method_6016(class_1294.field_5898);
        }
        if (Config.disableFireResistance) {
            player.method_6016(class_1294.field_5918);
        }
        if (Config.disableRegeneration) {
            player.method_6016(class_1294.field_5924);
        }
        if (Config.enableBlindness) {
            player.method_6092(new class_1293(class_1294.field_5919, Config.blindnessDuration, Config.blindnessLevel));
        }
        if (Config.enableSlowness) {
            player.method_6092(new class_1293(class_1294.field_5909, Config.slownessDuration, Config.slownessLevel));
        }
        if (Config.enableWeakness) {
            player.method_6092(new class_1293(class_1294.field_5911, Config.weaknessDuration, Config.weaknessLevel));
        }
        if (Config.enableMiningFatigue) {
            player.method_6092(new class_1293(class_1294.field_5901, Config.miningFatigueDuration, Config.miningFatigueLevel));
        }
        float health = player.method_6063() / Config.instantHealthDivider;
        health = Math.min(health, Config.maxInstantHealthValue);
        health = Math.max(health, Config.minInstantHealthValue);
        player.method_6033(health);
        HTNState.savePlayerData(player.method_5667());
    }
}

