/*
 * Decompiled with CFR 0.152.
 */
package dev.spagurder.htn.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MidnightConfigUpdateCallbackRegistry {
    private static final Map<String, Set<Runnable>> callbacks = new HashMap<String, Set<Runnable>>();

    public static void registerCallback(String modid, Runnable r) {
        callbacks.computeIfAbsent(modid, key -> new HashSet()).add(r);
    }

    public static void registerGlobalCallback(Runnable r) {
        MidnightConfigUpdateCallbackRegistry.registerCallback("", r);
    }

    public static void runCallbacks(String modid) {
        for (String key : Set.of("", modid)) {
            Set<Runnable> cbs = callbacks.get(key);
            if (cbs == null) continue;
            for (Runnable r : cbs) {
                r.run();
            }
        }
    }
}

