package dev.spagurder.htn;

import dev.spagurder.htn.data.HTNState;
import dev.spagurder.htn.data.PlayerData;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1324;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.server.MinecraftServer;
import java.time.Instant;

public class PostTotemHandler {

    public static void handlePostTotem(class_3222 player) {
        // Update player data
        PlayerData playerData = HTNState.playerState.get(player.method_5667());
        playerData.totemLastUsed = Instant.now().getEpochSecond();
        playerData.totemUsages++;

        if (Config.enableWarnings) {
            if (Config.useCooldown) {
                HTNUtil.sendMessage(player, "A totem cooldown of " + Config.usageCooldown + " seconds has been applied.");
            }
            if (Config.useUsageLimit) {
                HTNUtil.sendMessage(player, "You have " + (Config.usageLimit - playerData.totemUsages) + " totem usages left.");
            }
        }

        // Max health reduction
        if (Config.usageReducesMaxHealth) {
            class_1324 maxHealthAttribute = player.method_5996(class_5134.field_23716);
            if (maxHealthAttribute != null) {
                float prospectiveMaxHealth = player.method_6063() - Config.maxHealthReductionAmount;
                float maxHealth = Math.max(prospectiveMaxHealth, Config.minimumMaxHealth);
                playerData.maxHealthDeficit += player.method_6063() - maxHealth;
                if (maxHealth <= 0) {
                    playerData.outOfMaxHealth = true;
                    //? if >1.21.8 {
                    /*MinecraftServer server = player.level().getServer();
                    *///?} else {
                    MinecraftServer server = player.method_5682();
                    //?}
                    if (server != null) {
                        HTNUtil.broadcastMessage(server, player.method_5477().getString() + " used too many totems.");
                        HTNUtil.broadcastMessage(server, player.method_5477().getString() + " is now incapable of living.");
                        maxHealthAttribute.method_6192(1);
                        player.method_6012();
                        server.execute(() -> {
                            if (!player.method_29504()) {
                                //? if >=1.21.6 {
                                /*player.hurtServer(player.level(), player.damageSources().generic(), Float.MAX_VALUE);
                                *///?} else if >=1.21.2 {
                                player.method_64397(player.method_51469(), player.method_48923().method_48830(), Float.MAX_VALUE);
                                 //?} else {
                                /*player.hurt(player.damageSources().generic(), Float.MAX_VALUE);
                                 *///?}
                            }
                        });
                    } else {
                        HardcoreTotemNerf.LOGGER.error("Unable to get server instance");
                    }
                    return;
                } else {
                    maxHealthAttribute.method_6192(maxHealth);
                    player.method_6033(Math.min(player.method_6032(), maxHealth));
                }
            } else {
                HardcoreTotemNerf.LOGGER.error("MAX_HEALTH attribute missing from player {}", player.method_5667());
            }
        }

        // Disable buffs
        if (Config.disableAbsorption) {
            player.method_6016(class_1294.field_5898);
        }
        if (Config.disableFireResistance) {
            player.method_6016(class_1294.field_5918);
        }
        if (Config.disableRegeneration) {
            player.method_6016(class_1294.field_5924);
        }

        // Apply debuffs
        if (Config.enableBlindness) {
            player.method_6092(
                    new class_1293(
                            class_1294.field_5919,
                            Config.blindnessDuration,
                            Config.blindnessLevel)
            );
        }
        if (Config.enableSlowness) {
            player.method_6092(
                    new class_1293(
                            //? if >=1.21.5 {
                            class_1294.field_5909,
                            //?} else {
                            /*MobEffects.MOVEMENT_SLOWDOWN,
                             *///?}
                            Config.slownessDuration,
                            Config.slownessLevel)
            );
        }
        if (Config.enableWeakness) {
            player.method_6092(
                    new class_1293(
                            class_1294.field_5911,
                            Config.weaknessDuration,
                            Config.weaknessLevel)
            );
        }
        if (Config.enableMiningFatigue) {
            player.method_6092(
                    new class_1293(
                            //? if >=1.21.5 {
                            class_1294.field_5901,
                            //?} else {
                            /*MobEffects.DIG_SLOWDOWN,
                             *///?}
                            Config.miningFatigueDuration,
                            Config.miningFatigueLevel)
            );
        }

        // Update health
        float health = player.method_6063() / Config.instantHealthDivider;
        health = Math.min(health, Config.maxInstantHealthValue);
        health = Math.max(health, Config.minInstantHealthValue);
        player.method_6033(health);
        HTNState.savePlayerData(player);
    }

}
