/*
 * Decompiled with CFR 0.152.
 */
package dev.spagurder.htn;

import dev.spagurder.htn.Config;
import dev.spagurder.htn.HTNUtil;
import dev.spagurder.htn.HardcoreTotemNerf;
import dev.spagurder.htn.data.HTNState;
import dev.spagurder.htn.data.PlayerData;
import java.time.Instant;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class PostTotemHandler {
    public static void handlePostTotem(ServerPlayer player) {
        PlayerData playerData = HTNState.playerState.get(player.getUUID());
        playerData.totemLastUsed = Instant.now().getEpochSecond();
        ++playerData.totemUsages;
        if (Config.enableWarnings) {
            if (Config.useCooldown) {
                HTNUtil.sendMessage(player, "A totem cooldown of " + Config.usageCooldown + " seconds has been applied.");
            }
            if (Config.useUsageLimit) {
                HTNUtil.sendMessage(player, "You have " + (Config.usageLimit - playerData.totemUsages) + " totem usages left.");
            }
        }
        if (Config.usageReducesMaxHealth) {
            AttributeInstance maxHealthAttribute = player.getAttribute(Attributes.MAX_HEALTH);
            if (maxHealthAttribute != null) {
                float prospectiveMaxHealth = player.getMaxHealth() - Config.maxHealthReductionAmount;
                float maxHealth = Math.max(prospectiveMaxHealth, Config.minimumMaxHealth);
                playerData.maxHealthDeficit += player.getMaxHealth() - maxHealth;
                if (maxHealth <= 0.0f) {
                    playerData.outOfMaxHealth = true;
                    MinecraftServer server = player.getServer();
                    if (server != null) {
                        HTNUtil.broadcastMessage(server, player.getName().getString() + " used too many totems.");
                        HTNUtil.broadcastMessage(server, player.getName().getString() + " is now incapable of living.");
                        maxHealthAttribute.setBaseValue(1.0);
                        player.removeAllEffects();
                        server.execute(() -> {
                            if (!player.isDeadOrDying()) {
                                player.hurtServer(player.serverLevel(), player.damageSources().generic(), Float.MAX_VALUE);
                            }
                        });
                    } else {
                        HardcoreTotemNerf.LOGGER.error("Unable to get server instance");
                    }
                    return;
                }
                maxHealthAttribute.setBaseValue((double)maxHealth);
                player.setHealth(Math.min(player.getHealth(), maxHealth));
            } else {
                HardcoreTotemNerf.LOGGER.error("MAX_HEALTH attribute missing from player {}", (Object)player.getUUID());
            }
        }
        if (Config.disableAbsorption) {
            player.removeEffect(MobEffects.ABSORPTION);
        }
        if (Config.disableFireResistance) {
            player.removeEffect(MobEffects.FIRE_RESISTANCE);
        }
        if (Config.disableRegeneration) {
            player.removeEffect(MobEffects.REGENERATION);
        }
        if (Config.enableBlindness) {
            player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, Config.blindnessDuration, Config.blindnessLevel));
        }
        if (Config.enableSlowness) {
            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, Config.slownessDuration, Config.slownessLevel));
        }
        if (Config.enableWeakness) {
            player.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, Config.weaknessDuration, Config.weaknessLevel));
        }
        if (Config.enableMiningFatigue) {
            player.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, Config.miningFatigueDuration, Config.miningFatigueLevel));
        }
        float health = player.getMaxHealth() / Config.instantHealthDivider;
        health = Math.min(health, Config.maxInstantHealthValue);
        health = Math.max(health, Config.minInstantHealthValue);
        player.setHealth(health);
        HTNState.savePlayerData(player.getUUID());
    }
}

