/*
 * Decompiled with CFR 0.152.
 */
package dev.spagurder.htn.mixin.compat;

import dev.spagurder.htn.PostTotemHandler;
import dev.spagurder.htn.PreTotemHandler;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Pseudo
@Mixin(targets={"com.affehund.voidtotem.core.ModUtils"})
public class VoidTotemCompatMixin {
    @Inject(method={"hasVoidTotem"}, at={@At(value="HEAD")}, cancellable=true)
    private static void beforeHasVoidTotem(LivingEntity entity, CallbackInfoReturnable<Boolean> cir) {
        ServerPlayer player;
        if (entity instanceof ServerPlayer && !PreTotemHandler.doCheck(player = (ServerPlayer)entity)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"handleVoidTotem"}, at={@At(value="RETURN")})
    private static void afterHandleVoidTotem(LivingEntity entity, CallbackInfo ci) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PostTotemHandler.handlePostTotem(player);
        }
    }

    @Inject(method={"handleDefaultTotemActivation"}, at={@At(value="RETURN")})
    private static void afterHandleDefaultTotemActivation(LivingEntity entity, CallbackInfo ci) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PostTotemHandler.handlePostTotem(player);
        }
    }
}

