/*
 * Decompiled with CFR 0.152.
 */
package dev.spagurder.htn.mixin;

import dev.spagurder.htn.PostTotemHandler;
import dev.spagurder.htn.PreTotemHandler;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class TotemMixin {
    @Inject(method={"checkTotemDeathProtection"}, at={@At(value="HEAD")}, cancellable=true)
    private void beforeCheckTotemDeathProtection(DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        ServerPlayer player;
        LivingEntity entity = (LivingEntity)this;
        if (entity instanceof ServerPlayer && !PreTotemHandler.doCheck(player = (ServerPlayer)entity)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"checkTotemDeathProtection"}, at={@At(value="RETURN")})
    private void afterCheckTotemDeathProtection(DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity entity = (LivingEntity)this;
        if (((Boolean)cir.getReturnValue()).booleanValue() && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PostTotemHandler.handlePostTotem(player);
        }
    }
}

