package dev.spagurder.htn.mixin.compat;

import dev.spagurder.htn.PostTotemHandler;
import dev.spagurder.htn.PreTotemHandler;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Pseudo
@Mixin(targets = "xyz.hafemann.netheriteextras.event.ModEvents")
public class NetheriteExtrasCompatMixin {

    //? if fabric {
    @Inject(
            method = "lambda$registerModEvents$1",
            at = @At("HEAD"),
            cancellable = true
    )
    private static void beforeAllowDeathHandler(
            class_1309 entity, class_1282 damageSource,
            float damageAmount, CallbackInfoReturnable<Boolean> cir) {
        if (entity instanceof class_3222 player) {
            if (!PreTotemHandler.doCheck(player)) {
                cir.cancel();
            }
        }
    }

    @Inject(
            method = "lambda$registerModEvents$1",
            at = @At("RETURN")
    )
    private static void afterAllowDeathHandler(
            class_1309 entity, class_1282 damageSource,
            float damageAmount, CallbackInfoReturnable<Boolean> cir) {
        if (entity instanceof class_3222 player) {
            if (!cir.getReturnValue()) {
                PostTotemHandler.handlePostTotem(player);
            }
        }
    }
    //?}

}