package dev.spagurder.htn.mixin.compat;

import dev.spagurder.htn.PostTotemHandler;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Pseudo
@Mixin(targets = {
        "com.natamus.inventorytotem_common_fabric.events.TotemEvent",
        "com.natamus.inventorytotem_common_neoforge.events.TotemEvent",
        "com.natamus.inventorytotem_common_forge.events.TotemEvent"
})
public class InventoryTotemCompatMixin {

    @Inject(method = "allowPlayerDeath", at = @At("RETURN"), remap = false)
    private static void afterAllowPlayerDeath(class_3218 world, class_3222 player, CallbackInfoReturnable<Boolean> cir) {
        if (!cir.getReturnValue()) {
            PostTotemHandler.handlePostTotem(player);
        }
    }

}
