//? if fabric {
package dev.spagurder.htn.loaders.fabric;

import dev.spagurder.htn.HTNCommands;
import dev.spagurder.htn.HardcoreTotemNerf;
import dev.spagurder.htn.data.HTNState;
import dev.spagurder.htn.event.PlayerDeathHandler;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_3222;

public class FabricEntrypoint implements ModInitializer {

    @Override
    public void onInitialize() {
        HardcoreTotemNerf.initialize();
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            HTNState.loadPlayerData(handler.method_32311().method_5667());
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, sender) -> {
            HTNState.unloadAndSavePlayerData(handler.method_32311().method_5667());
        });
        ServerLivingEntityEvents.AFTER_DEATH.register(((entity, damageSource) -> {
            if (entity instanceof class_3222 player) {
                PlayerDeathHandler.onPlayerDeath(player);
            }
        }));
        CommandRegistrationCallback.EVENT.register(((dispatcher, registryAccess, environment) -> {
            HTNCommands.register(dispatcher);
        }));
    }

}
//?}
