/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.dialogrules;

import java.util.Locale;

public class ActionResolver {
    private static final ResolvedAction DUMMY_ACTION = new ResolvedAction(ActionType.NONE, "");

    public static ResolvedAction resolve(String value) {
        if (value == null || value.isEmpty()) {
            return DUMMY_ACTION;
        }
        ActionType type = ActionType.resolve(value);
        if (type.length() + 1 >= value.length() || type == ActionType.NONE) {
            return DUMMY_ACTION;
        }
        return new ResolvedAction(type, value.substring(type.length() + 1));
    }

    public record ResolvedAction(ActionType type, String value) {
    }

    public static enum ActionType {
        COMMAND,
        DISCONNECT,
        NONE;

        private static final ActionType[] values;

        public static ActionType resolve(String text) {
            for (ActionType value : values) {
                if (!text.toLowerCase(Locale.ROOT).startsWith(value.name().toLowerCase(Locale.ROOT))) continue;
                return value;
            }
            return NONE;
        }

        public int length() {
            return this.name().length();
        }

        static {
            values = ActionType.values();
        }
    }
}

