/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.dialogrules;

import ch.andre601.dialogrules.DialogRules;
import ch.andre601.dialogrules.RuleEntry;
import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.DialogRegistryEntry;
import io.papermc.paper.registry.data.dialog.action.DialogAction;
import io.papermc.paper.registry.data.dialog.body.DialogBody;
import io.papermc.paper.registry.data.dialog.type.DialogType;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.inventory.ItemStack;

public class DialogBuilder {
    private final List<DialogBody> bodies = new ArrayList<DialogBody>();
    private final MenuType type;
    private String title = "Server Rules";

    public static Dialog create(MenuType type, Audience audience) {
        List<RuleEntry> rules;
        UUID uuid = audience.get(Identity.UUID).orElse(null);
        if (uuid == null) {
            return null;
        }
        DialogBuilder builder = new DialogBuilder(type);
        builder.title(DialogRules.get().configManager().string("Server Rules", "title"));
        String description = DialogRules.get().configManager().string("", "description");
        if (description != null && !description.isEmpty()) {
            builder.description(description);
        }
        if ((rules = DialogRules.get().configManager().rules()) == null || rules.isEmpty()) {
            return null;
        }
        for (int i = 0; i < rules.size(); ++i) {
            RuleEntry entry = rules.get(i);
            builder.rule(entry, i);
        }
        return builder.build(uuid);
    }

    public DialogBuilder(MenuType type) {
        this.type = type;
    }

    public DialogBuilder title(String title) {
        this.title = title;
        return this;
    }

    public DialogBuilder description(String description) {
        this.bodies.add((DialogBody)DialogBody.plainMessage((Component)DialogRules.get().miniMessage().deserialize((Object)description)));
        return this;
    }

    public DialogBuilder rule(RuleEntry entry, int index) {
        if (entry.text().isEmpty()) {
            return this;
        }
        if (entry.item() != null) {
            this.bodies.add((DialogBody)DialogBody.item((ItemStack)entry.item()).description(DialogBody.plainMessage((Component)DialogRules.get().miniMessage().deserialize((Object)DialogRules.get().configManager().string("{num}) {text}", "ruleFormat").replace("{num}", String.valueOf(index + 1)).replace("{text}", entry.text())))).showTooltip(false).build());
        } else {
            this.bodies.add((DialogBody)DialogBody.plainMessage((Component)DialogRules.get().miniMessage().deserialize((Object)entry.text())));
        }
        return this;
    }

    public Dialog build(UUID uuid) {
        if (uuid == null) {
            throw new IllegalStateException("Received null UUID for Dialog!");
        }
        return Dialog.create(factory -> {
            if (this.type == MenuType.CONFIRMATION) {
                ((DialogRegistryEntry.Builder)factory.empty()).type((DialogType)DialogType.confirmation((ActionButton)ActionButton.builder((Component)DialogRules.get().miniMessage().deserialize((Object)DialogRules.get().configManager().string("Accept", "buttons", "accept", "text"))).action((DialogAction)DialogAction.customClick((Key)Key.key((String)("dialogrules:accept/" + String.valueOf(uuid))), null)).build(), (ActionButton)ActionButton.builder((Component)DialogRules.get().miniMessage().deserialize((Object)DialogRules.get().configManager().string("Decline", "buttons", "decline", "text"))).action((DialogAction)DialogAction.customClick((Key)Key.key((String)("dialogrules:decline/" + String.valueOf(uuid))), null)).build())).base(DialogBase.builder((Component)DialogRules.get().miniMessage().deserialize((Object)this.title)).canCloseWithEscape(false).body(this.bodies).build());
            } else {
                ((DialogRegistryEntry.Builder)factory.empty()).type((DialogType)DialogType.notice()).base(DialogBase.builder((Component)DialogRules.get().miniMessage().deserialize((Object)this.title)).body(this.bodies).build());
            }
        });
    }

    public static enum MenuType {
        CONFIRMATION,
        NOTICE;

    }
}

