/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.dialogrules;

import ch.andre601.dialogrules.ActionResolver;
import ch.andre601.dialogrules.commands.CmdDialogRules;
import ch.andre601.dialogrules.commands.CmdRules;
import ch.andre601.dialogrules.config.ConfigManager;
import ch.andre601.dialogrules.depends.cloud.annotations.AnnotationParser;
import ch.andre601.dialogrules.depends.cloud.execution.ExecutionCoordinator;
import ch.andre601.dialogrules.depends.cloud.paper.PaperCommandManager;
import ch.andre601.dialogrules.listeners.ClickListener;
import ch.andre601.dialogrules.listeners.PlayerConfigPhaseListener;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.connection.PlayerCommonConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class DialogRules
extends JavaPlugin {
    public static NamespacedKey KEY;
    private static DialogRules instance;
    private final Map<PlayerCommonConnection, CompletableFuture<ActionResolver.ActionType>> awaitingAction = new HashMap<PlayerCommonConnection, CompletableFuture<ActionResolver.ActionType>>();
    private final List<UUID> acceptsToProcess = new CopyOnWriteArrayList<UUID>();
    private final MiniMessage mm = MiniMessage.miniMessage();
    private ConfigManager configManager;

    public void onEnable() {
        try {
            Class.forName("io.papermc.paper.dialog.Dialog");
        }
        catch (ClassNotFoundException ignored) {
            this.getSLF4JLogger().warn("This version of Paper does not have the Dialog Feature for MC 1.21.7+!");
            this.getSLF4JLogger().warn("Please use at least 1.21.7 of Paper to use this plugin.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        instance = this;
        KEY = NamespacedKey.fromString((String)"accepted_rules", (Plugin)this);
        this.configManager = new ConfigManager();
        this.getSLF4JLogger().info("Loading config.yml...");
        this.configManager.loadConfig();
        this.getSLF4JLogger().info("Registering Events...");
        PlayerConfigPhaseListener.register();
        ClickListener.register();
        this.getSLF4JLogger().info("Register commands...");
        PaperCommandManager<CommandSourceStack> manager = PaperCommandManager.builder().executionCoordinator(ExecutionCoordinator.simpleCoordinator()).buildOnEnable((Plugin)this);
        new AnnotationParser<CommandSourceStack>(manager, CommandSourceStack.class).parse(new CmdDialogRules(), new CmdRules());
        this.processAccepts();
    }

    public void onDisable() {
    }

    public static DialogRules get() {
        return instance;
    }

    public ConfigManager configManager() {
        return this.configManager;
    }

    public MiniMessage miniMessage() {
        return this.mm;
    }

    public void queueAction(PlayerCommonConnection connection, CompletableFuture<ActionResolver.ActionType> future) {
        this.awaitingAction.put(connection, future);
    }

    public void removeAction(PlayerCommonConnection connection) {
        this.awaitingAction.remove(connection);
    }

    public void updateActionResult(PlayerCommonConnection connection) {
        CompletableFuture<ActionResolver.ActionType> future = this.awaitingAction.get(connection);
        if (future != null) {
            future.complete(null);
        }
    }

    public void queueAccepted(UUID uuid) {
        this.acceptsToProcess.add(uuid);
    }

    private void processAccepts() {
        this.getServer().getScheduler().runTaskTimer((Plugin)this, () -> {
            for (UUID uuid : this.acceptsToProcess) {
                Player player = this.getServer().getPlayer(uuid);
                if (player == null) continue;
                PersistentDataContainer pdc = player.getPersistentDataContainer();
                pdc.set(KEY, PersistentDataType.BOOLEAN, (Object)true);
                this.acceptsToProcess.remove(uuid);
            }
        }, 1L, 20L);
    }
}

