/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.dialogrules.config;

import ch.andre601.dialogrules.DialogRules;
import ch.andre601.dialogrules.RuleEntry;
import ch.andre601.dialogrules.config.RuleEntryDeserializer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public class ConfigManager {
    private final Path config = DialogRules.get().getDataPath().resolve("config.yml");
    private final Logger logger = DialogRules.get().getSLF4JLogger();
    ConfigurationNode node = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadConfig() {
        File folder = DialogRules.get().getDataFolder();
        if (!folder.exists() && !folder.mkdirs()) {
            this.logger.warn("Unable to create folder for plugin!");
            return false;
        }
        if (Files.exists(this.config, new LinkOption[0])) return this.reloadConfig();
        try (InputStream stream = ((Object)((Object)DialogRules.get())).getClass().getResourceAsStream("/config.yml");){
            if (stream == null) {
                this.logger.warn("Unable to create config.yml. InputStream was null!");
                boolean bl = false;
                return bl;
            }
            Files.copy(stream, this.config, new CopyOption[0]);
            this.logger.info("Successfully created config.yml!");
            return this.reloadConfig();
        }
        catch (IOException ex) {
            this.logger.warn("Encountered IOException will creating config.yml!", (Throwable)ex);
            return false;
        }
    }

    public boolean reloadConfig() {
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(this.config)).defaultOptions(options -> options.serializers(builder -> builder.register(RuleEntry.class, (TypeSerializer)RuleEntryDeserializer.INSTANCE)))).build();
        try {
            this.node = loader.load();
            return this.node != null;
        }
        catch (IOException ex) {
            this.logger.warn("Encountered IOException while loading config.yml!", (Throwable)ex);
            return false;
        }
    }

    public String string(String def, Object ... path) {
        return this.node.node(path).getString(def);
    }

    public boolean bool(Object ... path) {
        return this.node.node(path).getBoolean();
    }

    public ShowOn showOnPhase() {
        return ShowOn.resolve(this.node.node(new Object[]{"showOn"}).getString("none"));
    }

    public List<RuleEntry> rules() {
        try {
            return this.node.node(new Object[]{"rules"}).getList(RuleEntry.class);
        }
        catch (SerializationException ex) {
            return Collections.emptyList();
        }
    }

    public static enum ShowOn {
        CONFIGURE,
        JOIN,
        NONE;

        private static final ShowOn[] values;

        public static ShowOn resolve(String value) {
            for (ShowOn showOn : values) {
                if (!showOn.name().equalsIgnoreCase(value)) continue;
                return showOn;
            }
            return NONE;
        }

        static {
            values = ShowOn.values();
        }
    }
}

