/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.dialogrules.config;

import ch.andre601.dialogrules.DialogRules;
import ch.andre601.dialogrules.RuleEntry;
import java.lang.reflect.Type;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.TypeSerializer;

public class RuleEntryDeserializer
implements TypeSerializer<RuleEntry> {
    public static final RuleEntryDeserializer INSTANCE = new RuleEntryDeserializer();

    public RuleEntry deserialize(Type type, ConfigurationNode node) {
        String description = node.node(new Object[]{"text"}).getString("");
        if (description.isEmpty()) {
            return null;
        }
        String item = node.node(new Object[]{"item"}).getString("");
        ItemStack itemStack = null;
        if (!item.isEmpty()) {
            try {
                itemStack = Bukkit.getItemFactory().createItemStack(item);
            }
            catch (IllegalArgumentException ignored) {
                DialogRules.get().getSLF4JLogger().warn("Received invalid Item Input '{}'", (Object)item);
                DialogRules.get().getSLF4JLogger().warn("Make sure that it is a valid format!");
            }
        }
        return new RuleEntry(itemStack, description);
    }

    public void serialize(Type type, @Nullable RuleEntry obj, ConfigurationNode node) {
    }
}

