/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.dialogrules.depends.cloud.annotations.assembler;

import ch.andre601.dialogrules.depends.cloud.annotation.specifier.Completions;
import ch.andre601.dialogrules.depends.cloud.annotations.AnnotationParser;
import ch.andre601.dialogrules.depends.cloud.annotations.ArgumentMode;
import ch.andre601.dialogrules.depends.cloud.annotations.PreprocessorMapper;
import ch.andre601.dialogrules.depends.cloud.annotations.SyntaxFragment;
import ch.andre601.dialogrules.depends.cloud.annotations.assembler.ArgumentAssembler;
import ch.andre601.dialogrules.depends.cloud.annotations.descriptor.ArgumentDescriptor;
import ch.andre601.dialogrules.depends.cloud.component.CommandComponent;
import ch.andre601.dialogrules.depends.cloud.component.preprocessor.ComponentPreprocessor;
import ch.andre601.dialogrules.depends.cloud.parser.ArgumentParser;
import ch.andre601.dialogrules.depends.cloud.parser.ParserDescriptor;
import ch.andre601.dialogrules.depends.cloud.parser.ParserParameters;
import ch.andre601.dialogrules.depends.cloud.parser.standard.EitherParser;
import ch.andre601.dialogrules.depends.cloud.suggestion.Suggestion;
import ch.andre601.dialogrules.depends.cloud.suggestion.SuggestionProvider;
import ch.andre601.dialogrules.depends.cloud.type.Either;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.INTERNAL, consumers={"ch.andre601.dialogrules.depends.cloud.annotations.*"})
public final class ArgumentAssemblerImpl<C>
implements ArgumentAssembler<C> {
    private final AnnotationParser<C> annotationParser;

    public ArgumentAssemblerImpl(@NonNull AnnotationParser<C> annotationParser) {
        this.annotationParser = annotationParser;
    }

    @Override
    public @NonNull CommandComponent<C> assembleArgument(@NonNull SyntaxFragment syntaxFragment, @NonNull ArgumentDescriptor descriptor) {
        ArgumentParser<C, Object> parser;
        Parameter parameter = descriptor.parameter();
        List<Annotation> annotations = Arrays.asList(parameter.getAnnotations());
        TypeToken<?> token = TypeToken.get(parameter.getParameterizedType());
        ParserParameters parameters = this.annotationParser.manager().parserRegistry().parseAnnotations(token, annotations);
        if (GenericTypeReflector.isSuperType(Either.class, token.getType())) {
            TypeToken<?> primaryType = TypeToken.get(GenericTypeReflector.getTypeParameter(parameter.getParameterizedType(), Either.class.getTypeParameters()[0]));
            TypeToken<?> fallbackType = TypeToken.get(GenericTypeReflector.getTypeParameter(parameter.getParameterizedType(), Either.class.getTypeParameters()[1]));
            ParserDescriptor primary = this.annotationParser.manager().parserRegistry().createParser(primaryType, parameters).map(primaryParser -> ParserDescriptor.of(primaryParser, primaryType)).orElseThrow(() -> new IllegalArgumentException(String.format("Parameter '%s' has parser 'Either<%s, ?>' but no parser exists for that type", parameter.getName(), token.getType().getTypeName())));
            ParserDescriptor fallback = this.annotationParser.manager().parserRegistry().createParser(fallbackType, parameters).map(fallbackParser -> ParserDescriptor.of(fallbackParser, fallbackType)).orElseThrow(() -> new IllegalArgumentException(String.format("Parameter '%s' has parser 'Either<?, %s>' but no parser exists for that type", parameter.getName(), token.getType().getTypeName())));
            parser = EitherParser.eitherParser(primary, fallback).parser();
        } else {
            parser = descriptor.parserName() == null ? this.annotationParser.manager().parserRegistry().createParser(token, parameters).orElseThrow(() -> new IllegalArgumentException(String.format("Parameter '%s' has parser '%s' but no parser exists for that type", parameter.getName(), token.getType().getTypeName()))) : this.annotationParser.manager().parserRegistry().createParser(this.annotationParser.processString(descriptor.parserName()), parameters).orElseThrow(() -> new IllegalArgumentException(String.format("Parameter '%s' has parser '%s' but no parser exists for that type", parameter.getName(), token.getType().getTypeName())));
        }
        String argumentName = this.annotationParser.processString(descriptor.name());
        if (syntaxFragment.argumentMode() == ArgumentMode.LITERAL) {
            throw new IllegalArgumentException(String.format("Invalid command argument '%s': Missing syntax mapping", argumentName));
        }
        CommandComponent.Builder<Object, ?> componentBuilder = CommandComponent.builder();
        componentBuilder.commandManager(this.annotationParser.manager()).valueType(parameter.getType()).name(argumentName).parser(parser).required(syntaxFragment.argumentMode() == ArgumentMode.REQUIRED);
        Completions completions = parameter.getDeclaredAnnotation(Completions.class);
        if (completions != null) {
            List suggestions = Arrays.stream(completions.value().replace(" ", "").split(",")).map(Suggestion::suggestion).collect(Collectors.toList());
            componentBuilder.suggestionProvider(SuggestionProvider.suggesting(suggestions));
        } else if (descriptor.suggestions() != null) {
            String suggestionProviderName = this.annotationParser.processString(descriptor.suggestions());
            Optional<SuggestionProvider<C>> suggestionsFunction = this.annotationParser.manager().parserRegistry().getSuggestionProvider(suggestionProviderName);
            componentBuilder.suggestionProvider(suggestionsFunction.orElseThrow(() -> new IllegalArgumentException(String.format("There is no suggestion provider with name '%s'. Did you forget to register it?", suggestionProviderName))));
        }
        if (descriptor.description() != null) {
            componentBuilder.description(descriptor.description());
        }
        if (syntaxFragment.argumentMode() == ArgumentMode.OPTIONAL && descriptor.defaultValue() != null) {
            componentBuilder.defaultValue(descriptor.defaultValue());
        }
        for (Annotation annotation : annotations) {
            PreprocessorMapper<?, C> preprocessorMapper = this.annotationParser.preprocessorMappers().get(annotation.annotationType());
            if (preprocessorMapper == null) continue;
            ComponentPreprocessor<C> preprocessor = preprocessorMapper.mapAnnotation(annotation);
            componentBuilder.preprocessor(preprocessor);
        }
        return componentBuilder.build();
    }
}

