/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.dialogrules.listeners;

import ch.andre601.dialogrules.ActionResolver;
import ch.andre601.dialogrules.DialogRules;
import io.papermc.paper.event.player.PlayerCustomClickEvent;
import java.util.Locale;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ClickListener
implements Listener {
    public static void register() {
        new ClickListener();
    }

    private ClickListener() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)DialogRules.get());
    }

    @EventHandler
    public void onCustomClick(PlayerCustomClickEvent event) {
        String key = event.getIdentifier().key().asString().toLowerCase(Locale.ROOT);
        if (!key.startsWith("dialogrules:accept/") && !key.startsWith("dialogrules:decline/")) {
            return;
        }
        String type = key.startsWith("dialogrules:accept/") ? "accept" : "decline";
        UUID uuid = UUID.fromString(key.startsWith("dialogrules:accept/") ? key.substring("dialogrules:accept/".length()) : key.substring("dialogrules:decline/".length()));
        ActionResolver.ResolvedAction action = ActionResolver.resolve(DialogRules.get().configManager().string("NONE", "buttons", type, "action"));
        switch (action.type()) {
            case COMMAND: {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)action.value().replace("{uuid}", uuid.toString()));
                break;
            }
            case DISCONNECT: {
                event.getCommonConnection().disconnect(DialogRules.get().miniMessage().deserialize((Object)action.value()));
                break;
            }
        }
        DialogRules.get().updateActionResult(event.getCommonConnection());
        if (type.equals("accept")) {
            DialogRules.get().queueAccepted(uuid);
        }
    }
}

