/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.dialogrules.listeners;

import ch.andre601.dialogrules.ActionResolver;
import ch.andre601.dialogrules.DialogBuilder;
import ch.andre601.dialogrules.DialogRules;
import io.papermc.paper.connection.PlayerCommonConnection;
import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.event.connection.configuration.AsyncPlayerConnectionConfigureEvent;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.dialog.DialogLike;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class PlayerConfigPhaseListener
implements Listener {
    public static void register() {
        new PlayerConfigPhaseListener();
    }

    private PlayerConfigPhaseListener() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)DialogRules.get());
    }

    @EventHandler
    public void onPlayerConfigure(AsyncPlayerConnectionConfigureEvent event) {
        if (!DialogRules.get().configManager().bool("showOnJoin")) {
            return;
        }
        UUID uuid = event.getConnection().getProfile().getId();
        if (uuid == null) {
            DialogRules.get().getSLF4JLogger().warn("Unable to fetch UUID for a Player Configure phase!");
            return;
        }
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
        PersistentDataContainerView pdc = player.getPersistentDataContainer();
        Dialog dialog = DialogBuilder.create(DialogBuilder.MenuType.CONFIRMATION, event.getConnection().getAudience());
        if (dialog == null) {
            DialogRules.get().getSLF4JLogger().warn("Unable to display dialog to Player on Config Phase! Dialog was null.");
            return;
        }
        CompletableFuture<ActionResolver.ActionType> action = new CompletableFuture<ActionResolver.ActionType>();
        DialogRules.get().queueAction((PlayerCommonConnection)event.getConnection(), action);
        event.getConnection().getAudience().showDialog((DialogLike)dialog);
        action.join();
        DialogRules.get().removeAction((PlayerCommonConnection)event.getConnection());
    }
}

