/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.alliance;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.alliance.AllianceAction;
import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class AllianceServerboundPacket {
    AllianceAction action;
    public String targetPlayerName;
    public boolean boolValue;

    public static void doAllianceAction(AllianceAction action, String targetPlayerName) {
        PacketHandler.INSTANCE.sendToServer((Object)new AllianceServerboundPacket(action, targetPlayerName, false));
    }

    public static void doAllianceAction(AllianceAction action, boolean value) {
        PacketHandler.INSTANCE.sendToServer((Object)new AllianceServerboundPacket(action, "", value));
    }

    public AllianceServerboundPacket(AllianceAction action, String targetPlayerName, boolean boolValue) {
        this.action = action;
        this.targetPlayerName = targetPlayerName;
        this.boolValue = boolValue;
    }

    public AllianceServerboundPacket(FriendlyByteBuf buffer) {
        this.action = (AllianceAction)buffer.m_130066_(AllianceAction.class);
        this.targetPlayerName = buffer.m_130277_();
        this.boolValue = buffer.readBoolean();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.action);
        buffer.m_130070_(this.targetPlayerName);
        buffer.writeBoolean(this.boolValue);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                ReignOfNether.LOGGER.warn("AbilityServerboundPacket: Sender was null");
                success.set(false);
                return;
            }
            switch (this.action) {
                case REQUEST: {
                    MiscUtil.runPlayerCommand(player, "ally " + this.targetPlayerName);
                    break;
                }
                case CANCEL_REQUEST: {
                    MiscUtil.runPlayerCommand(player, "allycancelrequest " + this.targetPlayerName);
                    break;
                }
                case ACCEPT_REQUEST: {
                    MiscUtil.runPlayerCommand(player, "allyconfirm " + this.targetPlayerName);
                    break;
                }
                case DISBAND: {
                    MiscUtil.runPlayerCommand(player, "disband " + this.targetPlayerName);
                    break;
                }
                case SET_ALLY_CONTROL: {
                    MiscUtil.runPlayerCommand(player, "allycontrol " + this.boolValue);
                }
            }
            success.set(true);
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

