/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building;

import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.resources.BlockUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BuildingBlockData {
    public static ArrayList<BuildingBlock> getBuildingBlocksFromNbt(String structureName, LevelAccessor level) {
        ResourceManager resourceManager = level.m_5776_() ? Minecraft.m_91087_().m_91098_() : level.m_7654_().m_177941_();
        CompoundTag nbt = BuildingBlockData.getBuildingNbt(structureName, resourceManager);
        return BuildingBlockData.getBuildingBlocksFromNbt(nbt);
    }

    public static ArrayList<BuildingBlock> getBuildingBlocksFromNbt(CompoundTag nbt) {
        ArrayList<BuildingBlock> blocks = new ArrayList<BuildingBlock>();
        ListTag blocksNbt = nbt.m_128437_("blocks", 10);
        ArrayList<BlockState> palette = BuildingBlockData.getBuildingPalette(nbt);
        for (int i = 0; i < blocksNbt.size(); ++i) {
            CompoundTag blockNbt = blocksNbt.m_128728_(i);
            ListTag blockPosNbt = blockNbt.m_128437_("pos", 3);
            BlockPos bp = new BlockPos(blockPosNbt.m_128763_(0), blockPosNbt.m_128763_(1), blockPosNbt.m_128763_(2));
            BlockState bs = palette.get(blockNbt.m_128451_("state"));
            if (BlockUtils.isFallingLogBlock(bs)) {
                bs = BlockUtils.getNonFallingLog(bs);
            }
            if (bs.m_60734_() == Blocks.f_49990_ && !bs.m_60819_().m_76170_()) continue;
            blocks.add(new BuildingBlock(bp, bs));
        }
        return blocks;
    }

    public static ArrayList<BuildingBlock> getBuildingBlocksFromWorld(Level level, BlockPos originPos, BlockPos structurePos, Vec3i structureSize) {
        ArrayList<BuildingBlock> blocks = new ArrayList<BuildingBlock>();
        IntStream.range(originPos.m_123341_() + structurePos.m_123341_(), originPos.m_123341_() + structurePos.m_123341_() + structureSize.m_123341_()).forEachOrdered(x -> IntStream.range(originPos.m_123342_() + structurePos.m_123342_(), originPos.m_123342_() + structurePos.m_123342_() + structureSize.m_123342_()).forEachOrdered(y -> IntStream.range(originPos.m_123343_() + structurePos.m_123343_(), originPos.m_123343_() + structurePos.m_123343_() + structureSize.m_123343_()).forEachOrdered(z -> {
            BlockPos bp = new BlockPos(x, y, z);
            BlockState bs = level.m_8055_(bp);
            if (bs.m_60734_() != Blocks.f_49990_ || bs.m_60819_().m_76170_()) {
                blocks.add(new BuildingBlock(bp, bs));
            }
        })));
        return blocks;
    }

    public static CompoundTag getBuildingNbt(String structureName, ResourceManager resManager) {
        try {
            ResourceLocation rl = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)("structures/" + structureName + ".nbt"));
            Optional rs = resManager.m_213713_(rl);
            return NbtIo.m_128939_((InputStream)((Resource)rs.get()).m_215507_());
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public static ArrayList<BlockState> getBuildingPalette(CompoundTag nbt) {
        ArrayList<BlockState> palette = new ArrayList<BlockState>();
        ListTag paletteNbt = nbt.m_128437_("palette", 10);
        for (int i = 0; i < paletteNbt.size(); ++i) {
            palette.add(NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)paletteNbt.m_128728_(i)));
        }
        return palette;
    }

    public static BuildingBlock getBuildingBlockByPos(ArrayList<BuildingBlock> blocks, BlockPos bp) {
        List<BuildingBlock> results = blocks.stream().filter(b -> b.getBlockPos().equals((Object)bp)).toList();
        if (results.size() > 0) {
            return results.get(0);
        }
        return null;
    }
}

