/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.solegendary.reignofnether.alliance.AlliancesClient;
import com.solegendary.reignofnether.api.ReignOfNetherRegistries;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerboundPacket;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.monsters.Laboratory;
import com.solegendary.reignofnether.building.buildings.neutral.NeutralTransportPortal;
import com.solegendary.reignofnether.building.buildings.piglins.CentralPortal;
import com.solegendary.reignofnether.building.buildings.piglins.PortalBasic;
import com.solegendary.reignofnether.building.buildings.placements.BeaconPlacement;
import com.solegendary.reignofnether.building.buildings.placements.PortalPlacement;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.buildings.shared.AbstractBridge;
import com.solegendary.reignofnether.building.buildings.villagers.Castle;
import com.solegendary.reignofnether.building.buildings.villagers.Library;
import com.solegendary.reignofnether.building.buildings.villagers.TownCentre;
import com.solegendary.reignofnether.building.custombuilding.CustomBuilding;
import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.fogofwar.FogOfWarClientEvents;
import com.solegendary.reignofnether.gamerules.GameruleClient;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.nether.NetherBlocks;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.player.PlayerColors;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.sandbox.SandboxClientEvents;
import com.solegendary.reignofnether.tutorial.TutorialClientEvents;
import com.solegendary.reignofnether.unit.Relationship;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import com.solegendary.reignofnether.util.MyRenderer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.BeaconScreen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.KelpBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BuildingClientEvents {
    static final Minecraft MC = Minecraft.m_91087_();
    private static final ArrayList<BuildingPlacement> buildings = new ArrayList();
    private static final ArrayList<BuildingPlacement> selectedBuildings = new ArrayList();
    private static Building buildingToPlace = null;
    private static Building lastBuildingToPlace = null;
    private static ArrayList<BuildingBlock> blocksToDraw = new ArrayList();
    private static boolean replacedTexture = false;
    private static Rotation buildingRotation = Rotation.NONE;
    private static Vec3i buildingDimensions = new Vec3i(0, 0, 0);
    private static long lastLeftClickTime = 0L;
    private static final long DOUBLE_CLICK_TIME_MS = 500L;
    private static final float MIN_SUPPORTED_BLOCKS_PERCENT = 0.6f;
    private static final float MIN_NETHER_BLOCKS_PERCENT = 0.8f;
    private static final int MIN_BRIDGE_SIZE = 10;
    private static final float MIN_BRIDGE_LIQUID_BLOCKS_PERCENT = 0.2f;
    private static final float MAX_BRIDGE_LIQUID_BLOCKS_PERCENT = 0.95f;
    private static int bridgePlaceState = 0;
    private static final int VIS_CHECK_TICKS_MAX = 10;
    private static int ticksToNextVisCheck = 10;

    public static int getTotalPopulationSupply(String playerName) {
        if (ResearchClient.hasCheat("foodforthought")) {
            return GameruleClient.maxPopulation;
        }
        int totalPopulationSupply = 0;
        for (BuildingPlacement building : buildings) {
            if (!building.ownerName.equals(playerName) || !building.isBuilt) continue;
            totalPopulationSupply += building.getBuilding().cost.population;
        }
        return Math.min(GameruleClient.maxPopulation, totalPopulationSupply);
    }

    public static ArrayList<BuildingBlock> getBlocksToDraw() {
        return blocksToDraw;
    }

    public static BuildingPlacement getPreselectedBuilding() {
        for (BuildingPlacement building : buildings) {
            if (!building.isPosInsideBuilding(CursorClientEvents.getPreselectedBlockPos())) continue;
            return building;
        }
        return null;
    }

    public static ArrayList<BuildingPlacement> getSelectedBuildings() {
        return selectedBuildings;
    }

    public static List<BuildingPlacement> getBuildings() {
        return buildings;
    }

    public static void clearSelectedBuildings() {
        selectedBuildings.clear();
    }

    public static void addSelectedBuilding(BuildingPlacement building) {
        CursorClientEvents.setLeftClickAction(null);
        if (!FogOfWarClientEvents.isBuildingInBrightChunk(building)) {
            return;
        }
        selectedBuildings.add(building);
        selectedBuildings.sort(Comparator.comparing(b -> {
            if (b.getBuilding() instanceof CustomBuilding) {
                return b.getBuilding().name;
            }
            ReignOfNetherRegistries.BUILDING.m_7981_((Object)b.getBuilding()).toString();
            return "";
        }));
        UnitClientEvents.clearSelectedUnits();
    }

    private static boolean isBuildingToPlaceABridge() {
        return buildingToPlace instanceof AbstractBridge;
    }

    public static void switchHudToIdlestBuilding() {
        if (HudClientEvents.hudSelectedPlacement == null || BuildingClientEvents.MC.f_91074_ == null) {
            return;
        }
        BuildingPlacement idlestBuilding = null;
        List<BuildingPlacement> sameNameBuildings = selectedBuildings.stream().filter(b -> b.getBuilding().equals(HudClientEvents.hudSelectedPlacement.getBuilding()) && b.isBuilt && b.ownerName.equals(BuildingClientEvents.MC.f_91074_.m_7755_().getString())).toList();
        float prodTicksLeftMax = Float.MAX_VALUE;
        for (BuildingPlacement building : sameNameBuildings) {
            if (!(building instanceof ProductionPlacement)) continue;
            ProductionPlacement prodB = (ProductionPlacement)building;
            Float prodTicksLeft = prodB.productionQueue.stream().map(p -> Float.valueOf(p.ticksLeft)).reduce(Float.valueOf(0.0f), Float::sum);
            if (!(prodTicksLeft.floatValue() < prodTicksLeftMax)) continue;
            prodTicksLeftMax = prodTicksLeft.floatValue();
            idlestBuilding = building;
        }
        if (idlestBuilding != null) {
            HudClientEvents.hudSelectedPlacement = idlestBuilding;
        }
    }

    public static void setBuildingToPlace(Building building) {
        buildingToPlace = building;
        if (buildingToPlace != lastBuildingToPlace && buildingToPlace != null) {
            try {
                Building building2 = buildingToPlace;
                if (building2 instanceof AbstractBridge) {
                    AbstractBridge bridge = (AbstractBridge)building2;
                    blocksToDraw = bridge.getRelativeBlockData((LevelAccessor)BuildingClientEvents.MC.f_91073_, BuildingClientEvents.isBridgeDiagonal());
                } else {
                    blocksToDraw = buildingToPlace.getRelativeBlockData((LevelAccessor)BuildingClientEvents.MC.f_91073_);
                }
                buildingDimensions = BuildingUtils.getBuildingSize(blocksToDraw);
                buildingRotation = Rotation.NONE;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            lastBuildingToPlace = buildingToPlace;
        }
    }

    public static Building getBuildingToPlace() {
        return buildingToPlace;
    }

    public static void replaceOverlayTexture() {
        NativeImage nativeimage = BuildingClientEvents.MC.f_91063_.f_109075_.f_118084_.m_117991_();
        int bgr = MiscUtil.reverseHexRGB(65280);
        if (nativeimage != null) {
            nativeimage.m_84988_(0, 0, bgr | 0xB2000000);
            RenderSystem.activeTexture((int)33985);
            BuildingClientEvents.MC.f_91063_.f_109075_.f_118084_.m_117966_();
            nativeimage.m_85013_(0, 0, 0, 0, 0, nativeimage.m_84982_(), nativeimage.m_85084_(), false, true, false, false);
            RenderSystem.activeTexture((int)33984);
        }
    }

    public static void drawBuildingToPlace(PoseStack matrix, BlockPos originPos, int forceColour) {
        float g;
        if (buildingToPlace == null) {
            return;
        }
        boolean valid = BuildingClientEvents.isBuildingPlacementValid(originPos);
        int minX = 999999;
        int minY = 999999;
        int minZ = 999999;
        int maxX = -999999;
        int maxY = -999999;
        int maxZ = -999999;
        for (BuildingBlock block : blocksToDraw) {
            int overlayColour;
            if (buildingToPlace != null && BuildingClientEvents.isBuildingToPlaceABridge() && BuildingClientEvents.MC.f_91073_ != null && AbstractBridge.shouldCullBlock(originPos.m_7918_(0, 1, 0), block, (Level)BuildingClientEvents.MC.f_91073_)) continue;
            BlockRenderDispatcher renderer = MC.m_91289_();
            BlockState bs = block.getBlockState();
            BlockPos bp = block.getBlockPos().m_121955_((Vec3i)originPos);
            matrix.m_85836_();
            Entity cam = BuildingClientEvents.MC.f_91075_;
            matrix.m_85837_((double)bp.m_123341_() - cam.m_20185_(), (double)bp.m_123342_() - cam.m_20186_() - 0.6, (double)bp.m_123343_() - cam.m_20189_());
            int n = overlayColour = valid ? OverlayTexture.m_118093_((int)0, (int)0) : OverlayTexture.m_118093_((int)0, (int)3);
            if (forceColour == 1) {
                overlayColour = OverlayTexture.m_118093_((int)0, (int)0);
            } else if (forceColour == 2) {
                overlayColour = OverlayTexture.m_118093_((int)0, (int)3);
            }
            renderer.renderSingleBlock(bs, matrix, (MultiBufferSource)MC.m_91269_().m_110108_(), 0xF000F0, overlayColour, ModelData.EMPTY, null);
            matrix.m_85849_();
            if (bp.m_123341_() < minX) {
                minX = bp.m_123341_();
            }
            if (bp.m_123342_() < minY) {
                minY = bp.m_123342_();
            }
            if (bp.m_123343_() < minZ) {
                minZ = bp.m_123343_();
            }
            if (bp.m_123341_() > maxX) {
                maxX = bp.m_123341_();
            }
            if (bp.m_123342_() > maxY) {
                maxY = bp.m_123342_();
            }
            if (bp.m_123343_() <= maxZ) continue;
            maxZ = bp.m_123343_();
        }
        ++maxX;
        minY = (int)((float)minY + 1.05f);
        ++maxZ;
        float r = valid ? 0.0f : 1.0f;
        float f = g = valid ? 1.0f : 0.0f;
        if (valid && buildingToPlace instanceof PortalBasic && !BuildingClientEvents.isOnNetherBlocks(blocksToDraw, originPos)) {
            r = 0.5f;
            g = 0.5f;
        }
        if (forceColour == 1) {
            r = 0.0f;
            g = 1.0f;
        } else if (forceColour == 2) {
            r = 1.0f;
            g = 0.0f;
        }
        if (minY < 0) {
            --minY;
        }
        ResourceLocation rl = ResourceLocation.parse((String)"forge:textures/white.png");
        AABB aabb = new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)minY, (double)maxZ);
        MyRenderer.drawLineBox(matrix, aabb, r, g, 0.0f, 0.5f);
        MyRenderer.drawSolidBox(matrix, aabb, Direction.UP, r, g, 0.0f, 0.5f, rl);
        AABB aabb2 = new AABB((double)minX, -64.0, (double)minZ, (double)maxX, (double)minY, (double)maxZ);
        MyRenderer.drawLineBox(matrix, aabb2, r, g, 0.0f, 0.25f);
    }

    public static boolean isBuildingPlacementValid(BlockPos originPos) {
        return !BuildingClientEvents.isBuildingPlacementInAir(originPos) && !BuildingClientEvents.isBuildingPlacementClipping(originPos) && !BuildingClientEvents.isOverlappingAnyOtherBuilding() && BuildingClientEvents.isNonPiglinOrOnNetherBlocks(originPos) && BuildingClientEvents.isNonBridgeOrValidBridge(originPos) && FogOfWarClientEvents.isInBrightChunk(originPos) && BuildingClientEvents.isBuildingPlacementWithinWorldBorder(originPos) && BuildingClientEvents.isNotTutorialOrNearValidCapitolPosition(originPos);
    }

    public static void checkBuildingPlacementValidityWithMessages(BlockPos originPos) {
        if (!BuildingClientEvents.isBuildingPlacementWithinWorldBorder(originPos)) {
            HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"building.reignofnether.outside_map", (Object[])new Object[0]));
        } else if (BuildingClientEvents.isBuildingPlacementInAir(originPos)) {
            HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"building.reignofnether.ground_not_flat", (Object[])new Object[0]));
        } else if (BuildingClientEvents.isBuildingPlacementClipping(originPos)) {
            HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"building.reignofnether.ground_not_flat", (Object[])new Object[0]));
        } else if (BuildingClientEvents.isOverlappingAnyOtherBuilding()) {
            HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"building.reignofnether.too_close", (Object[])new Object[0]));
        } else if (!BuildingClientEvents.isNonPiglinOrOnNetherBlocks(originPos)) {
            HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"building.reignofnether.must_be_nether", (Object[])new Object[0]));
        } else if (!BuildingClientEvents.isNonBridgeOrValidBridge(originPos)) {
            HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"building.reignofnether.must_be_liquid", (Object[])new Object[0]));
        } else if (!FogOfWarClientEvents.isInBrightChunk(originPos)) {
            HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"building.reignofnether.unexplored", (Object[])new Object[0]));
        } else if (!BuildingClientEvents.isNotTutorialOrNearValidCapitolPosition(originPos)) {
            HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"building.reignofnether.build_centre_here", (Object[])new Object[0]));
            OrthoviewClientEvents.forceMoveCam(TutorialClientEvents.BUILD_CAM_POS, 50);
        }
    }

    private static boolean isBuildingPlacementClipping(BlockPos originPos) {
        if (BuildingClientEvents.MC.f_91073_ == null) {
            return false;
        }
        if (BuildingClientEvents.isBuildingToPlaceABridge() || GameruleClient.slantedBuilding) {
            return false;
        }
        for (BuildingBlock block : blocksToDraw) {
            BlockPos bp = block.getBlockPos().m_121955_((Vec3i)originPos).m_7918_(0, 1, 0);
            if (!BuildingClientEvents.MC.f_91073_.m_8055_(bp).m_280296_() && BuildingClientEvents.MC.f_91073_.m_8055_(bp).m_60819_().m_76178_() || !block.getBlockState().m_280296_() && block.getBlockState().m_60819_().m_76178_()) continue;
            return true;
        }
        return false;
    }

    private static boolean isBuildingPlacementInAir(BlockPos originPos) {
        if (BuildingClientEvents.isBuildingToPlaceABridge() || GameruleClient.slantedBuilding) {
            return false;
        }
        int solidBlocksBelow = 0;
        int blocksBelow = 0;
        for (BuildingBlock block : blocksToDraw) {
            if (block.getBlockPos().m_123342_() != 0 || BuildingClientEvents.MC.f_91073_ == null) continue;
            BlockPos bp = block.getBlockPos().m_121955_((Vec3i)originPos).m_7918_(0, 1, 0);
            BlockState bs = block.getBlockState();
            BlockState bsBelow = BuildingClientEvents.MC.f_91073_.m_8055_(bp.m_7495_());
            if (!bs.m_280296_() || bsBelow.m_60734_() instanceof IceBlock) continue;
            ++blocksBelow;
            if (!bsBelow.m_280296_() || bsBelow.m_60734_() instanceof LeavesBlock) continue;
            ++solidBlocksBelow;
        }
        if (blocksBelow <= 0) {
            return false;
        }
        return (float)solidBlocksBelow / (float)blocksBelow < 0.6f;
    }

    private static boolean isOverlappingAnyOtherBuilding() {
        BlockPos origin = BuildingClientEvents.getBuildingOriginPos(CursorClientEvents.getPreselectedBlockPos());
        Vec3i originOffset = new Vec3i(origin.m_123341_(), origin.m_123342_(), origin.m_123343_());
        BlockPos minPos = BuildingUtils.getMinCorner(blocksToDraw).m_121955_(originOffset);
        BlockPos maxPos = BuildingUtils.getMaxCorner(blocksToDraw).m_121955_(originOffset);
        for (BuildingPlacement building : buildings) {
            for (BuildingBlock block : building.blocks) {
                BlockPos bp;
                if (BuildingClientEvents.isBuildingToPlaceABridge() && building.getBuilding() instanceof AbstractBridge || (bp = block.getBlockPos()).m_123341_() < minPos.m_123341_() || bp.m_123341_() > maxPos.m_123341_() || bp.m_123342_() < minPos.m_123342_() || bp.m_123342_() > maxPos.m_123342_() || bp.m_123343_() < minPos.m_123343_() || bp.m_123343_() > maxPos.m_123343_()) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isNonPiglinOrOnNetherBlocks(BlockPos originPos) {
        if (BuildingClientEvents.isBuildingToPlaceABridge()) {
            return true;
        }
        if (buildingToPlace.getFaction() != Faction.PIGLINS || buildingToPlace instanceof CentralPortal) {
            return true;
        }
        if (buildingToPlace instanceof PortalBasic) {
            return true;
        }
        return BuildingClientEvents.isOnNetherBlocks(blocksToDraw, originPos);
    }

    public static boolean isOnNetherBlocks(List<BuildingBlock> blocks, BlockPos originPos) {
        int netherBlocksBelow = 0;
        int blocksBelow = 0;
        for (BuildingBlock block : blocks) {
            if (block.getBlockPos().m_123342_() != 0 || BuildingClientEvents.MC.f_91073_ == null) continue;
            BlockPos bp = block.getBlockPos().m_121955_((Vec3i)originPos).m_7918_(0, 1, 0);
            BlockState bs = block.getBlockState();
            BlockState bsBelow = BuildingClientEvents.MC.f_91073_.m_8055_(bp.m_7495_());
            if (!bs.m_280296_()) continue;
            ++blocksBelow;
            if (!NetherBlocks.isNetherBlock((Level)BuildingClientEvents.MC.f_91073_, bp.m_7495_())) continue;
            ++netherBlocksBelow;
        }
        if (blocksBelow <= 0) {
            return false;
        }
        return (float)netherBlocksBelow / (float)blocksBelow > 0.8f;
    }

    private static boolean isNonBridgeOrValidBridge(BlockPos originPos) {
        if (!BuildingClientEvents.isBuildingToPlaceABridge()) {
            return true;
        }
        int placeableBlocks = 0;
        for (BuildingBlock block : blocksToDraw) {
            if (AbstractBridge.shouldCullBlock(originPos.m_7918_(0, 1, 0), block, (Level)BuildingClientEvents.MC.f_91073_) || block.getBlockState().m_60795_()) continue;
            ++placeableBlocks;
        }
        if (placeableBlocks < 10) {
            return false;
        }
        int bridgeBlocks = 0;
        int waterBlocksClipping = 0;
        for (BuildingBlock block : blocksToDraw) {
            if (block.getBlockState().m_60795_() || BuildingClientEvents.MC.f_91073_ == null) continue;
            BlockPos bp = block.getBlockPos().m_121955_((Vec3i)originPos).m_7918_(0, 1, 0);
            BlockState bs = block.getBlockState();
            BlockState bsWorld = BuildingClientEvents.MC.f_91073_.m_8055_(bp);
            if (block.getBlockPos().m_123342_() == 1 && bs.m_60734_() instanceof FenceBlock && !bsWorld.m_60819_().m_76178_()) {
                return false;
            }
            if (block.getBlockPos().m_123342_() != 0) continue;
            ++bridgeBlocks;
            if (bsWorld.m_60819_().m_76178_() && !(bsWorld.m_60734_() instanceof SeagrassBlock) && !(bsWorld.m_60734_() instanceof KelpBlock)) continue;
            ++waterBlocksClipping;
        }
        if (bridgeBlocks <= 0) {
            return false;
        }
        float percentWater = (float)waterBlocksClipping / (float)bridgeBlocks;
        return percentWater > 0.2f && percentWater < 0.95f;
    }

    private static boolean isNotTutorialOrNearValidCapitolPosition(BlockPos originPos) {
        if (!TutorialClientEvents.isEnabled()) {
            return true;
        }
        if (!(buildingToPlace instanceof TownCentre)) {
            return true;
        }
        return TutorialClientEvents.BUILD_CAPITOL_POS.m_123331_((Vec3i)originPos) < 625.0;
    }

    private static boolean isBuildingPlacementWithinWorldBorder(BlockPos originPos) {
        if (BuildingClientEvents.MC.f_91073_ == null || buildingToPlace == null) {
            return false;
        }
        int minX = 999999;
        int minZ = 999999;
        int maxX = -999999;
        int maxZ = -999999;
        for (BlockPos bp : blocksToDraw.stream().map(BuildingBlock::getBlockPos).toList()) {
            if (bp.m_123341_() < minX) {
                minX = bp.m_123341_();
            }
            if (bp.m_123343_() < minZ) {
                minZ = bp.m_123343_();
            }
            if (bp.m_123341_() > maxX) {
                maxX = bp.m_123341_();
            }
            if (bp.m_123343_() <= maxZ) continue;
            maxZ = bp.m_123343_();
        }
        int buildingRadius = Math.max(maxZ - minZ, maxX - minX) / 2;
        BlockPos cursorPos = CursorClientEvents.getPreselectedBlockPos();
        return BuildingClientEvents.MC.f_91073_.m_6857_().m_61941_((double)cursorPos.m_123341_(), (double)cursorPos.m_123343_()) > (double)buildingRadius;
    }

    public static BlockPos getBuildingOriginPos(BlockPos bp) {
        int xAdj = 0;
        int zAdj = 0;
        int xRadius = buildingDimensions.m_123341_() / 2;
        int zRadius = buildingDimensions.m_123343_() / 2;
        switch (buildingRotation) {
            case NONE: {
                xAdj = -xRadius;
                zAdj = -zRadius;
                break;
            }
            case CLOCKWISE_90: {
                xAdj = xRadius;
                zAdj = -zRadius;
                break;
            }
            case CLOCKWISE_180: {
                xAdj = xRadius;
                zAdj = zRadius;
                break;
            }
            case COUNTERCLOCKWISE_90: {
                xAdj = -xRadius;
                zAdj = zRadius;
            }
        }
        if (BuildingClientEvents.isBuildingToPlaceABridge()) {
            bp = bp.m_7918_(0, -1, 0);
        }
        return bp.m_7918_(xAdj, 0, zAdj);
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent evt) throws NoSuchFieldException {
        if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        if (!OrthoviewClientEvents.isEnabled()) {
            return;
        }
        BuildingClientEvents.drawBuildingToPlace(evt.getPoseStack(), BuildingClientEvents.getBuildingOriginPos(CursorClientEvents.getPreselectedBlockPos()), 0);
        BuildingPlacement preselectedBuilding = BuildingClientEvents.getPreselectedBuilding();
        for (BuildingPlacement building : buildings) {
            boolean isInBrightChunk = FogOfWarClientEvents.isBuildingInBrightChunk(building);
            AABB aabb = new AABB(building.minCorner, building.maxCorner.m_7918_(1, 1, 1));
            Color colorHex = new Color(PlayerColors.getPlayerDisplayColorHex(building.ownerName));
            float r = (float)colorHex.getRed() / 255.0f;
            float g = (float)colorHex.getGreen() / 255.0f;
            float b = (float)colorHex.getBlue() / 255.0f;
            if (isInBrightChunk) {
                if (selectedBuildings.contains(building)) {
                    MyRenderer.drawLineBox(evt.getPoseStack(), aabb, 1.0f, 1.0f, 1.0f, 1.0f);
                } else if (building.equals(preselectedBuilding) && !HudClientEvents.isMouseOverAnyButtonOrHud()) {
                    if (HudClientEvents.hudSelectedEntity instanceof WorkerUnit && MiscUtil.isRightClickDown(MC)) {
                        MyRenderer.drawLineBox(evt.getPoseStack(), aabb, 1.0f, 1.0f, 1.0f, 1.0f);
                    } else {
                        MyRenderer.drawLineBox(evt.getPoseStack(), aabb, 1.0f, 1.0f, 1.0f, MiscUtil.isRightClickDown(MC) ? 1.0f : 0.5f);
                    }
                }
            }
            MyRenderer.drawBoxBottom(evt.getPoseStack(), aabb, r, g, b, 0.5f);
        }
        for (BuildingPlacement selBuilding : selectedBuildings) {
            PortalPlacement portal;
            float a;
            if (selBuilding instanceof ProductionPlacement) {
                ProductionPlacement selProdBuilding = (ProductionPlacement)selBuilding;
                a = MiscUtil.getOscillatingFloat(0.25, 0.75);
                if (!selProdBuilding.getRallyPoints().isEmpty() && BuildingClientEvents.MC.f_91073_ != null) {
                    Vec3 lastPos = Vec3.m_82539_((Vec3i)selProdBuilding.centrePos.m_7494_());
                    for (BlockPos bp : selProdBuilding.getRallyPoints()) {
                        MyRenderer.drawLine(evt.getPoseStack(), lastPos, Vec3.m_82539_((Vec3i)bp.m_7494_()), 0.0f, 1.0f, 0.0f, a);
                        if (BuildingClientEvents.MC.f_91073_.m_8055_(bp.m_7918_(0, 1, 0)).m_60734_() instanceof SnowLayerBlock) {
                            AABB aabb = new AABB(bp);
                            aabb = aabb.m_165893_(aabb.f_82292_ + (double)0.13f);
                            MyRenderer.drawSolidBox(evt.getPoseStack(), aabb, Direction.UP, 0.0f, 1.0f, 0.0f, a, ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"textures/white.png"));
                        } else {
                            MyRenderer.drawBlockFace(evt.getPoseStack(), Direction.UP, bp, 0.0f, 1.0f, 0.0f, a);
                        }
                        lastPos = Vec3.m_82539_((Vec3i)bp.m_7494_());
                    }
                } else if (selProdBuilding.getRallyPointEntity() != null) {
                    LivingEntity le = selProdBuilding.getRallyPointEntity();
                    MyRenderer.drawLine(evt.getPoseStack(), new Vec3((double)selBuilding.centrePos.m_123341_(), (double)selBuilding.centrePos.m_123342_(), (double)selBuilding.centrePos.m_123343_()), new Vec3(le.m_20185_(), le.m_20188_(), le.m_20189_()), 0.0f, 1.0f, 0.0f, a);
                    MyRenderer.drawLineBoxOutlineOnly(evt.getPoseStack(), le.m_20191_(), 0.0f, 1.0f, 0.0f, a, false);
                }
            }
            if (!(selBuilding instanceof PortalPlacement) || !(portal = (PortalPlacement)selBuilding).hasDestination()) continue;
            a = MiscUtil.getOscillatingFloat(0.25, 0.75);
            MyRenderer.drawLine(evt.getPoseStack(), selBuilding.centrePos, portal.destination, 0.0f, 1.0f, 0.0f, a);
        }
    }

    public static boolean isBridgeDiagonal() {
        return bridgePlaceState % 2 != 0;
    }

    @SubscribeEvent
    public static void onMouseScroll(ScreenEvent.MouseScrolled.Post evt) {
        if (buildingToPlace != null) {
            Building building = buildingToPlace;
            if (building instanceof AbstractBridge) {
                AbstractBridge bridge = (AbstractBridge)building;
                if ((bridgePlaceState += evt.getScrollDelta() > 0.0 ? 1 : -1) < 0) {
                    bridgePlaceState = 3;
                } else if (bridgePlaceState > 3) {
                    bridgePlaceState = 0;
                }
                try {
                    blocksToDraw = bridge.getRelativeBlockData((LevelAccessor)BuildingClientEvents.MC.f_91073_, BuildingClientEvents.isBridgeDiagonal());
                    buildingDimensions = BuildingUtils.getBuildingSize(blocksToDraw);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                buildingRotation = rotationDelta = List.of(Integer.valueOf(0), Integer.valueOf(1)).contains(bridgePlaceState) ? Rotation.NONE : Rotation.CLOCKWISE_90;
                if (bridgePlaceState == 2) {
                    blocksToDraw.replaceAll(buildingBlock -> buildingBlock.move((LevelAccessor)BuildingClientEvents.MC.f_91073_, new BlockPos(-5, 0, 5)));
                }
                blocksToDraw.replaceAll(buildingBlock -> buildingBlock.rotate((LevelAccessor)BuildingClientEvents.MC.f_91073_, rotationDelta));
            } else {
                rotationDelta = evt.getScrollDelta() > 0.0 ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90;
                buildingRotation = buildingRotation.m_55952_(rotationDelta);
                blocksToDraw.replaceAll(buildingBlock -> buildingBlock.rotate((LevelAccessor)BuildingClientEvents.MC.f_91073_, rotationDelta));
            }
        }
    }

    @SubscribeEvent
    public static void onMouseClick(ScreenEvent.MouseButtonPressed.Pre evt) {
        if (!OrthoviewClientEvents.isEnabled()) {
            return;
        }
        if (HudClientEvents.isMouseOverAnyButtonOrHud()) {
            BuildingClientEvents.setBuildingToPlace(null);
            return;
        }
        BlockPos pos = BuildingClientEvents.getBuildingOriginPos(CursorClientEvents.getPreselectedBlockPos());
        if (evt.getButton() == 0) {
            BuildingPlacement preSelBuilding = BuildingClientEvents.getPreselectedBuilding();
            if (buildingToPlace != null && BuildingClientEvents.isBuildingPlacementValid(pos) && BuildingClientEvents.MC.f_91074_ != null) {
                Building building = buildingToPlace;
                ArrayList<Integer> builderIds = new ArrayList<Integer>();
                for (LivingEntity builderEntity : UnitClientEvents.getSelectedUnits()) {
                    if (!(builderEntity instanceof WorkerUnit)) continue;
                    builderIds.add(builderEntity.m_19879_());
                }
                if (Keybindings.shiftMod.isDown()) {
                    String string;
                    LivingEntity builderEntity;
                    BlockPos blockPos = BuildingClientEvents.isBuildingToPlaceABridge() && bridgePlaceState == 2 ? pos.m_7918_(-5, 0, -5) : pos;
                    builderEntity = HudClientEvents.hudSelectedEntity;
                    if (builderEntity instanceof Unit) {
                        Unit unit = (Unit)builderEntity;
                        string = unit.getOwnerName();
                    } else {
                        string = BuildingClientEvents.MC.f_91074_.m_7755_().getString();
                    }
                    BuildingServerboundPacket.placeAndQueueBuilding(building, blockPos, buildingRotation, string, builderIds.stream().mapToInt(i -> i).toArray(), BuildingClientEvents.isBridgeDiagonal());
                    for (LivingEntity entity : UnitClientEvents.getSelectedUnits()) {
                        if (!(entity instanceof Unit)) continue;
                        Unit unit = (Unit)entity;
                        unit.getCheckpoints().removeIf(c -> c.bp == null || !BuildingUtils.isPosInsideAnyBuilding(true, c.bp));
                        MiscUtil.addUnitCheckpoint(unit, CursorClientEvents.getPreselectedBlockPos().m_7494_(), false);
                        if (!(unit instanceof WorkerUnit)) continue;
                        WorkerUnit workerUnit = (WorkerUnit)((Object)unit);
                        workerUnit.getBuildRepairGoal().ignoreNextCheckpoint = true;
                    }
                } else {
                    String string;
                    String ownerName;
                    boolean hasSelectedWorkers = false;
                    for (LivingEntity entity : UnitClientEvents.getSelectedUnits()) {
                        if (!(entity instanceof WorkerUnit)) continue;
                        hasSelectedWorkers = true;
                        break;
                    }
                    if (SandboxClientEvents.isSandboxPlayer(ownerName = BuildingClientEvents.MC.f_91074_.m_7755_().getString()) && !hasSelectedWorkers && !(buildingToPlace instanceof AbstractBridge)) {
                        if (SandboxClientEvents.relationship == Relationship.NEUTRAL) {
                            ownerName = "";
                        } else if (SandboxClientEvents.relationship == Relationship.HOSTILE) {
                            ownerName = "Enemy";
                        }
                    }
                    BlockPos blockPos = BuildingClientEvents.isBuildingToPlaceABridge() && bridgePlaceState == 2 ? pos.m_7918_(-5, 0, -5) : pos;
                    LivingEntity workerUnit = HudClientEvents.hudSelectedEntity;
                    if (workerUnit instanceof Unit) {
                        Unit unit = (Unit)workerUnit;
                        string = unit.getOwnerName();
                    } else {
                        string = ownerName;
                    }
                    BuildingServerboundPacket.placeBuilding(buildingToPlace, blockPos, buildingRotation, string, builderIds.stream().mapToInt(i -> i).toArray(), BuildingClientEvents.isBridgeDiagonal());
                    BuildingClientEvents.setBuildingToPlace(null);
                    if (hasSelectedWorkers) {
                        for (LivingEntity entity : UnitClientEvents.getSelectedUnits()) {
                            if (!(entity instanceof Unit)) continue;
                            Unit unit = (Unit)entity;
                            MiscUtil.addUnitCheckpoint(unit, CursorClientEvents.getPreselectedBlockPos().m_7494_(), true);
                            if (!(unit instanceof WorkerUnit)) continue;
                            WorkerUnit workerUnit2 = (WorkerUnit)((Object)unit);
                            workerUnit2.getBuildRepairGoal().ignoreNextCheckpoint = true;
                        }
                    }
                }
            } else if (buildingToPlace == null) {
                if (selectedBuildings.size() == 1 && BuildingClientEvents.MC.f_91073_ != null && !Keybindings.shiftMod.isDown() && (System.currentTimeMillis() - lastLeftClickTime < 500L || Keybindings.ctrlMod.isDown()) && preSelBuilding != null && selectedBuildings.contains(preSelBuilding)) {
                    lastLeftClickTime = 0L;
                    BuildingPlacement selBuilding = selectedBuildings.get(0);
                    BlockPos centre = selBuilding.centrePos;
                    ArrayList<BuildingPlacement> nearbyBuildings = BuildingClientEvents.getBuildingsWithinRange(new Vec3((double)centre.m_123341_(), (double)centre.m_123342_(), (double)centre.m_123343_()), OrthoviewClientEvents.getZoom() * 2.0f, selBuilding.getBuilding());
                    BuildingClientEvents.clearSelectedBuildings();
                    for (BuildingPlacement building : nearbyBuildings) {
                        if (BuildingClientEvents.getPlayerToBuildingRelationship(building) != Relationship.OWNED) continue;
                        BuildingClientEvents.addSelectedBuilding(building);
                    }
                } else if (preSelBuilding != null && CursorClientEvents.getLeftClickAction() == null) {
                    boolean deselected = false;
                    if (Keybindings.shiftMod.isDown()) {
                        deselected = selectedBuildings.remove(preSelBuilding);
                    }
                    if (Keybindings.shiftMod.isDown() && !deselected && BuildingClientEvents.getPlayerToBuildingRelationship(preSelBuilding) == Relationship.OWNED) {
                        BuildingClientEvents.addSelectedBuilding(preSelBuilding);
                    } else if (!deselected && UnitClientEvents.getPreselectedUnits().size() == 0) {
                        BuildingClientEvents.clearSelectedBuildings();
                        BuildingClientEvents.addSelectedBuilding(preSelBuilding);
                    }
                }
            } else {
                BuildingClientEvents.checkBuildingPlacementValidityWithMessages(pos);
            }
            if (selectedBuildings.size() > 1) {
                selectedBuildings.removeIf(b -> BuildingClientEvents.getPlayerToBuildingRelationship(b) != Relationship.OWNED);
            }
            lastLeftClickTime = System.currentTimeMillis();
        } else if (evt.getButton() == 1 && !Keybindings.altMod.isDown()) {
            for (BuildingPlacement selBuilding : selectedBuildings) {
                if (!(selBuilding instanceof ProductionPlacement)) continue;
                ProductionPlacement selProdBuilding = (ProductionPlacement)selBuilding;
                if (BuildingClientEvents.getPlayerToBuildingRelationship(selBuilding) != Relationship.OWNED) continue;
                if (!UnitClientEvents.getPreselectedUnits().isEmpty()) {
                    LivingEntity rallyPointEntity = UnitClientEvents.getPreselectedUnits().get(0);
                    selProdBuilding.setRallyPointEntity(rallyPointEntity);
                    BuildingServerboundPacket.setRallyPointEntity(selBuilding.originPos, rallyPointEntity.m_19879_());
                    continue;
                }
                BlockPos rallyPoint = CursorClientEvents.getPreselectedBlockPos();
                if (Keybindings.shiftMod.isDown()) {
                    selProdBuilding.addRallyPoint(rallyPoint);
                    BuildingServerboundPacket.addRallyPoint(selBuilding.originPos, rallyPoint);
                    continue;
                }
                selProdBuilding.setRallyPoint(rallyPoint);
                BuildingServerboundPacket.setRallyPoint(selBuilding.originPos, rallyPoint);
            }
        }
    }

    @SubscribeEvent
    public static void onButtonPress(ScreenEvent.KeyPressed.Pre evt) {
        if (evt.getKeyCode() == 342) {
            buildingToPlace = null;
        }
        if (evt.getKeyCode() == 261) {
            boolean isSandboxPlayer = BuildingClientEvents.MC.f_91074_ != null && SandboxClientEvents.isSandboxPlayer(BuildingClientEvents.MC.f_91074_.m_7755_().getString());
            BuildingPlacement building = HudClientEvents.hudSelectedPlacement;
            if (building != null && (building.isBuilt && BuildingClientEvents.getPlayerToBuildingRelationship(building) == Relationship.OWNED || isSandboxPlayer)) {
                HudClientEvents.hudSelectedPlacement = null;
                BuildingServerboundPacket.cancelBuilding(building.minCorner, BuildingClientEvents.MC.f_91074_.m_7755_().getString());
            }
        }
    }

    @SubscribeEvent
    public static void onButtonPress(ScreenEvent.KeyReleased.Post evt) {
        if (BuildingClientEvents.MC.f_91073_ != null && BuildingClientEvents.MC.f_91074_ != null && evt.getKeyCode() == 340) {
            BuildingClientEvents.setBuildingToPlace(null);
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        if (--ticksToNextVisCheck <= 0) {
            ticksToNextVisCheck = 10;
            selectedBuildings.removeIf(b -> !FogOfWarClientEvents.isBuildingInBrightChunk(b));
        }
        if (!replacedTexture) {
            BuildingClientEvents.replaceOverlayTexture();
            replacedTexture = true;
        }
        if (BuildingClientEvents.MC.f_91073_ != null && BuildingClientEvents.MC.f_91073_.m_46472_() == Level.f_46428_) {
            for (BuildingPlacement building : buildings) {
                if (MC.m_91104_()) continue;
                building.tick((Level)BuildingClientEvents.MC.f_91073_);
            }
            selectedBuildings.removeIf(BuildingPlacement::shouldBeDestroyed);
            buildings.removeIf(b -> {
                if (b.shouldBeDestroyed()) {
                    b.unFreezeChunks();
                    return true;
                }
                return false;
            });
        }
    }

    @SubscribeEvent
    public static void onScreenOpen(ScreenEvent.Opening evt) {
        BlockPos bp;
        if (evt.getScreen() instanceof BeaconScreen && BuildingUtils.findBuilding(true, bp = Item.m_41435_((Level)BuildingClientEvents.MC.f_91073_, (Player)BuildingClientEvents.MC.f_91074_, (ClipContext.Fluid)ClipContext.Fluid.NONE).m_82425_()) instanceof BeaconPlacement) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onScreenClose(ScreenEvent.Closing evt) {
        if (evt.getScreen() instanceof ContainerScreen && BuildingClientEvents.MC.f_91073_ != null && BuildingClientEvents.MC.f_91074_ != null) {
            BlockPos bp = Item.m_41435_((Level)BuildingClientEvents.MC.f_91073_, (Player)BuildingClientEvents.MC.f_91074_, (ClipContext.Fluid)ClipContext.Fluid.NONE).m_82425_();
            BuildingServerboundPacket.checkStockpileChests(bp);
        }
    }

    public static ArrayList<BuildingPlacement> getBuildingsWithinRange(Vec3 pos, float range, Building building) {
        ArrayList<BuildingPlacement> retBuildings = new ArrayList<BuildingPlacement>();
        for (BuildingPlacement placement : buildings) {
            BlockPos centre;
            Vec3 centreVec3;
            if (!placement.getBuilding().equals(building) || !(pos.m_82554_(centreVec3 = new Vec3((double)(centre = placement.centrePos).m_123341_(), (double)centre.m_123342_(), (double)centre.m_123343_())) <= (double)range)) continue;
            retBuildings.add(placement);
        }
        return retBuildings;
    }

    public static void placeBuilding(Building building, BlockPos pos, Rotation rotation, String ownerName, int numBlocksToPlace, boolean isDiagonalBridge, int upgradeLevel, boolean isBuilt, PortalPlacement.PortalType portalType, BlockPos portalDestination, boolean forPlayerLoggingIn) {
        LivingEntity entity;
        BuildingPlacement newBuilding = BuildingUtils.getNewBuildingPlacement(building, (Level)BuildingClientEvents.MC.f_91073_, pos, rotation, ownerName, isDiagonalBridge);
        for (BuildingPlacement placement : buildings) {
            if (!newBuilding.originPos.equals((Object)placement.originPos)) continue;
            return;
        }
        while (numBlocksToPlace > 0) {
            newBuilding.addToBlockPlaceQueue(new BuildingBlock(new BlockPos(0, 0, 0), Blocks.f_50016_.m_49966_()));
            --numBlocksToPlace;
        }
        if (newBuilding != null && BuildingClientEvents.MC.f_91074_ != null) {
            newBuilding.isBuilt = isBuilt;
            if (isBuilt && forPlayerLoggingIn) {
                newBuilding.highestBlockCountReached = newBuilding.getBlocksTotal();
            }
            if (upgradeLevel > 0) {
                Building building2 = newBuilding.getBuilding();
                if (building2 instanceof Castle) {
                    Castle castle = (Castle)building2;
                    newBuilding.changeStructure("castle_with_flag");
                } else {
                    building2 = newBuilding.getBuilding();
                    if (building2 instanceof Laboratory) {
                        Laboratory lab = (Laboratory)building2;
                        newBuilding.changeStructure("laboratory_lightning");
                    } else if (newBuilding instanceof PortalPlacement) {
                        PortalPlacement portal = (PortalPlacement)newBuilding;
                        if (!(newBuilding.getBuilding() instanceof NeutralTransportPortal)) {
                            portal.changeStructure(portalType);
                        }
                        if (portalType == PortalPlacement.PortalType.TRANSPORT) {
                            portal.destination = portalDestination;
                        }
                    } else {
                        building2 = newBuilding.getBuilding();
                        if (building2 instanceof Library) {
                            Library library = (Library)building2;
                            newBuilding.changeStructure("library_grand");
                        } else if (newBuilding instanceof BeaconPlacement) {
                            BeaconPlacement beacon = (BeaconPlacement)newBuilding;
                            beacon.changeStructure(upgradeLevel);
                        }
                    }
                }
            }
            buildings.add(newBuilding);
            if (FogOfWarClientEvents.isEnabled()) {
                newBuilding.freezeChunks(BuildingClientEvents.MC.f_91074_.m_7755_().getString(), forPlayerLoggingIn);
            }
        }
        if ((entity = HudClientEvents.hudSelectedEntity) instanceof WorkerUnit) {
            Unit unit;
            WorkerUnit workerUnit = (WorkerUnit)entity;
            if (entity instanceof Unit && (unit = (Unit)entity).getOwnerName().equals(ownerName)) {
                ((Unit)entity).resetBehaviours();
                workerUnit.getBuildRepairGoal().setBuildingTarget(newBuilding);
            }
        }
    }

    public static void syncBuilding(BuildingPlacement serverBuilding, int blocksPlaced, String ownerName) {
        for (BuildingPlacement building : buildings) {
            if (!building.originPos.equals((Object)serverBuilding.originPos)) continue;
            building.setServerBlocksPlaced(blocksPlaced);
            building.ownerName = ownerName;
        }
    }

    public static Relationship getPlayerToBuildingRelationship(BuildingPlacement building) {
        if (BuildingClientEvents.MC.f_91074_ != null) {
            String buildingOwnerName;
            String playerName = BuildingClientEvents.MC.f_91074_.m_7755_().getString();
            if (playerName.equals(buildingOwnerName = building.ownerName)) {
                return Relationship.OWNED;
            }
            if (AlliancesClient.isAllied(playerName, buildingOwnerName)) {
                return Relationship.FRIENDLY;
            }
            if (buildingOwnerName.isBlank()) {
                return Relationship.NEUTRAL;
            }
            return Relationship.HOSTILE;
        }
        return Relationship.NEUTRAL;
    }

    public static boolean hasFinishedBuilding(Building building) {
        for (BuildingPlacement bpl : buildings) {
            if (!bpl.getBuilding().isTypeOf(building) || !bpl.isBuilt || (BuildingClientEvents.MC.f_91074_ == null || !bpl.ownerName.equals(BuildingClientEvents.MC.f_91074_.m_7755_().getString())) && !BuildingClientEvents.allyHasFinishedBuilding(building)) continue;
            return true;
        }
        return false;
    }

    public static boolean allyHasFinishedBuilding(Building building) {
        if (!AlliancesClient.canControlAlly(HudClientEvents.hudSelectedEntity)) {
            return false;
        }
        String allyName = "";
        LivingEntity livingEntity = HudClientEvents.hudSelectedEntity;
        if (livingEntity instanceof Unit) {
            Unit unit = (Unit)livingEntity;
            allyName = unit.getOwnerName();
        }
        for (BuildingPlacement bpl : buildings) {
            if (!bpl.getBuilding().isTypeOf(building) || !bpl.isBuilt || BuildingClientEvents.MC.f_91074_ == null || !bpl.ownerName.equals(allyName)) continue;
            return true;
        }
        return false;
    }

    public static void syncBeacon(UnitAction action, BlockPos beaconPos, boolean activate) {
        BeaconPlacement beacon = BuildingUtils.getBeacon(true);
        if (beacon == null) {
            return;
        }
        if (activate) {
            MobEffect effect = BeaconPlacement.getMobEffectForAction(action);
            if (effect != null) {
                beacon.activate(effect);
            }
        } else {
            beacon.deactivate();
        }
    }
}

